/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.utils;

import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.TemporalAdjusters;

public class MGL_LastQuarterUtils {
    public static void main(String[] args) {
        LocalDate[] quarterDates = MGL_LastQuarterUtils.getLastQuarterDates();
        System.out.println("\u4e0a\u4e2a\u5b63\u5ea6\u8d77\u59cb\u65e5\u671f\uff1a" + String.valueOf(quarterDates[0]));
        System.out.println("\u4e0a\u4e2a\u5b63\u5ea6\u7ed3\u675f\u65e5\u671f\uff1a" + String.valueOf(quarterDates[1]));
        LocalDate today = LocalDate.now();
        LocalDate[] lastQuarterRange = MGL_LastQuarterUtils.getLastQuarterRange(today);
        System.out.println("\u4e0a\u4e2a\u5b63\u5ea6\u7684\u8d77\u59cb\u65e5\u671f: " + String.valueOf(lastQuarterRange[0]));
        System.out.println("\u4e0a\u4e2a\u5b63\u5ea6\u7684\u7ed3\u675f\u65e5\u671f: " + String.valueOf(lastQuarterRange[1]));
    }

    private static LocalDate[] getLastQuarterDates() {
        return MGL_LastQuarterUtils.getLastQuarterDates(LocalDate.now());
    }

    public static LocalDate[] getLastQuarterRange() {
        return MGL_LastQuarterUtils.getLastQuarterRange(LocalDate.now());
    }

    public static LocalDate[] getLastQuarterRange(LocalDate date) {
        Month firstMonthOfLastQuarter;
        Month firstMonthOfQuarter = date.getMonth().firstMonthOfQuarter();
        int year = date.getYear();
        if (firstMonthOfQuarter == Month.JANUARY) {
            firstMonthOfLastQuarter = Month.OCTOBER;
            --year;
        } else {
            firstMonthOfLastQuarter = firstMonthOfQuarter.minus(3L);
        }
        LocalDate startOfLastQuarter = LocalDate.of(year, firstMonthOfLastQuarter, 1);
        LocalDate endOfLastQuarter = startOfLastQuarter.plusMonths(2L).with(TemporalAdjusters.lastDayOfMonth());
        return new LocalDate[]{startOfLastQuarter, endOfLastQuarter};
    }

    private static LocalDate[] getLastQuarterDates(LocalDate today) {
        int currentQuarter = MGL_LastQuarterUtils.getCurrentQuarterNo();
        int lastQuarter = currentQuarter == 1 ? 4 : currentQuarter - 1;
        LocalDate startDate = MGL_LastQuarterUtils.getQuarterStartDate(today.getYear(), lastQuarter);
        LocalDate endDate = MGL_LastQuarterUtils.getQuarterEndDate(today.getYear(), lastQuarter);
        if (lastQuarter == 4) {
            startDate = startDate.minusYears(1L);
            endDate = endDate.minusYears(1L);
        }
        return new LocalDate[]{startDate, endDate};
    }

    public static int getCurrentQuarterNo() {
        LocalDate today = LocalDate.now();
        return (today.getMonthValue() - 1) / 3 + 1;
    }

    public static LocalDate getCurrentQuarterStartDate() {
        LocalDate today = LocalDate.now();
        int currentQuarter = MGL_LastQuarterUtils.getCurrentQuarterNo();
        return MGL_LastQuarterUtils.getQuarterStartDate(today.getYear(), currentQuarter);
    }

    public static LocalDate getCurrentQuarterEndDate() {
        LocalDate today = LocalDate.now();
        int currentQuarter = MGL_LastQuarterUtils.getCurrentQuarterNo();
        return MGL_LastQuarterUtils.getQuarterEndDate(today.getYear(), currentQuarter);
    }

    public static LocalDate getQuarterStartDate(int year, int quarter) {
        return switch (quarter) {
            case 1 -> LocalDate.of(year, Month.JANUARY, 1);
            case 2 -> LocalDate.of(year, Month.APRIL, 1);
            case 3 -> LocalDate.of(year, Month.JULY, 1);
            case 4 -> LocalDate.of(year, Month.OCTOBER, 1);
            default -> throw new IllegalArgumentException("Invalid quarter: " + quarter);
        };
    }

    public static LocalDate getQuarterEndDate(int year, int quarter) {
        return switch (quarter) {
            case 1 -> LocalDate.of(year, Month.MARCH, 31);
            case 2 -> LocalDate.of(year, Month.JUNE, 30);
            case 3 -> LocalDate.of(year, Month.SEPTEMBER, 30);
            case 4 -> LocalDate.of(year, Month.DECEMBER, 31);
            default -> throw new IllegalArgumentException("Invalid quarter: " + quarter);
        };
    }
}

