/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.core.c.MGL_CryptoCommonUtils;
import tech.mgl.core.utils.MGL_Asserts;

public class MGL_FormulaUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)MGL_CryptoCommonUtils.class.getSimpleName());
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("[0-9.+-/*()= ]+");
    private static final Map<String, Integer> OPT_PRIORITY_MAP = new HashMap<String, Integer>(){
        private static final long serialVersionUID = 6968472606692771458L;
        {
            this.put("(", 0);
            this.put("+", 2);
            this.put("-", 2);
            this.put("*", 3);
            this.put("/", 3);
            this.put(")", 7);
            this.put("=", 20);
        }
    };

    public static synchronized BigDecimal execute(String ex) {
        MGL_Asserts.notBlank(ex, "\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Matcher matcher = EXPRESSION_PATTERN.matcher(ex);
        MGL_Asserts.state(matcher.matches(), "\u8868\u8fbe\u5f0f\u542b\u6709\u975e\u6cd5\u5b57\u7b26\uff01");
        Stack<String> optStack = new Stack<String>();
        Stack<BigDecimal> numStack = new Stack<BigDecimal>();
        StringBuilder curNumBuilder = new StringBuilder(16);
        block10: for (int i = 0; i < ex.length(); ++i) {
            char c = ex.charAt(i);
            if (c == ' ') continue;
            if (c >= '0' && c <= '9' || c == '.') {
                curNumBuilder.append(c);
                continue;
            }
            if (!curNumBuilder.isEmpty()) {
                numStack.push(new BigDecimal(curNumBuilder.toString()));
                curNumBuilder.delete(0, curNumBuilder.length());
            }
            String curOpt = String.valueOf(c);
            if (optStack.empty()) {
                optStack.push(curOpt);
                continue;
            }
            switch (curOpt) {
                case "(": {
                    optStack.push(curOpt);
                    continue block10;
                }
                case ")": {
                    MGL_FormulaUtils.directCalc(optStack, numStack, true);
                    continue block10;
                }
                case "=": {
                    MGL_FormulaUtils.directCalc(optStack, numStack, false);
                    return numStack.pop();
                }
                default: {
                    MGL_FormulaUtils.compareAndCalc(optStack, numStack, curOpt);
                }
            }
        }
        if (!curNumBuilder.isEmpty()) {
            numStack.push(new BigDecimal(curNumBuilder.toString()));
        }
        MGL_FormulaUtils.directCalc(optStack, numStack, false);
        return numStack.pop();
    }

    private static void compareAndCalc(Stack<String> optStack, Stack<BigDecimal> numStack, String curOpt) {
        String peekOpt = optStack.peek();
        int priority = MGL_FormulaUtils.getPriority(peekOpt, curOpt);
        if (priority == -1 || priority == 0) {
            String opt = optStack.pop();
            BigDecimal num2 = numStack.pop();
            BigDecimal num1 = numStack.pop();
            BigDecimal bigDecimal = MGL_FormulaUtils.floatingPointCalc(opt, num1, num2);
            numStack.push(bigDecimal);
            if (optStack.empty()) {
                optStack.push(curOpt);
            } else {
                MGL_FormulaUtils.compareAndCalc(optStack, numStack, curOpt);
            }
        } else {
            optStack.push(curOpt);
        }
    }

    private static void directCalc(Stack<String> optStack, Stack<BigDecimal> numStack, boolean isBracket) {
        String opt = optStack.pop();
        BigDecimal num2 = numStack.pop();
        BigDecimal num1 = numStack.pop();
        BigDecimal bigDecimal = MGL_FormulaUtils.floatingPointCalc(opt, num1, num2);
        numStack.push(bigDecimal);
        if (isBracket) {
            if ("(".equals(optStack.peek())) {
                optStack.pop();
            } else {
                MGL_FormulaUtils.directCalc(optStack, numStack, isBracket);
            }
        } else if (!optStack.empty()) {
            MGL_FormulaUtils.directCalc(optStack, numStack, isBracket);
        }
    }

    private static BigDecimal floatingPointCalc(String opt, BigDecimal bigDecimal1, BigDecimal bigDecimal2) {
        BigDecimal resultBigDecimal = new BigDecimal(0);
        switch (opt) {
            case "+": 
            case "\u52a0": 
            case "plus": 
            case "add": {
                resultBigDecimal = bigDecimal1.add(bigDecimal2);
                break;
            }
            case "-": 
            case "\u51cf": {
                resultBigDecimal = bigDecimal1.subtract(bigDecimal2);
                break;
            }
            case "*": 
            case "\u4e58": {
                resultBigDecimal = bigDecimal1.multiply(bigDecimal2);
                break;
            }
            case "/": 
            case "\u9664": {
                resultBigDecimal = bigDecimal1.divide(bigDecimal2, 10, RoundingMode.HALF_DOWN);
                break;
            }
        }
        return resultBigDecimal;
    }

    private static int getPriority(String opt1, String opt2) {
        return OPT_PRIORITY_MAP.get(opt2) - OPT_PRIORITY_MAP.get(opt1);
    }

    public static boolean isDoubleEquals(double value1, double value2) {
        logger.info("\u6b63\u786e\u7ed3\u679c={}, \u5b9e\u9645\u8ba1\u7b97\u7ed3\u679c={}", (Object)value1, (Object)value2);
        return Math.abs(value1 - value2) <= 1.0E-4;
    }

    private MGL_FormulaUtils() {
    }
}

