/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.utils;

import java.lang.reflect.Method;
import org.slf4j.LoggerFactory;

public class MGL_EnumsUtils {
    public static <T extends Enum<T>> T getByFieldValue(String fieldValue, T[] values) {
        return (T)MGL_EnumsUtils.getByFieldValue(null, (String)fieldValue, values);
    }

    public static <T extends Enum<T>> T getByFieldValue(String fieldKey, String fieldValue, T[] values) {
        if (fieldValue == null || values == null || values.length == 0) {
            return null;
        }
        String effectiveFieldKey = fieldKey == null || fieldKey.trim().isEmpty() ? "code" : fieldKey;
        for (T enumConstant : values) {
            try {
                Method method = enumConstant.getClass().getDeclaredMethod("get" + MGL_EnumsUtils.capitalize(effectiveFieldKey), new Class[0]);
                Object value = method.invoke(enumConstant, new Object[0]);
                if (!fieldValue.equals(String.valueOf(value))) continue;
                return enumConstant;
            }
            catch (Exception e) {
                LoggerFactory.getLogger(MGL_EnumsUtils.class).warn(e.getMessage());
            }
        }
        return null;
    }

    public static <T extends Enum<T>> T getByFieldValue(String fieldValue, Class<T> clazz) {
        return MGL_EnumsUtils.getByFieldValue(null, fieldValue, clazz);
    }

    public static <T extends Enum<T>> T getByFieldValue(String fieldKey, String fieldValue, Class<T> clazz) {
        Enum[] constants;
        if (fieldValue == null || clazz == null || !clazz.isEnum()) {
            return null;
        }
        String effectiveFieldKey = fieldKey == null || fieldKey.trim().isEmpty() ? "code" : fieldKey;
        for (Enum constant : constants = (Enum[])clazz.getEnumConstants()) {
            try {
                Method method = clazz.getDeclaredMethod("get" + MGL_EnumsUtils.capitalize(effectiveFieldKey), new Class[0]);
                Object value = method.invoke((Object)constant, new Object[0]);
                if (!fieldValue.equals(String.valueOf(value))) continue;
                return (T)constant;
            }
            catch (Exception e) {
                LoggerFactory.getLogger(MGL_EnumsUtils.class).warn(e.getMessage());
            }
        }
        return null;
    }

    private static String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }
}

