/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.utils;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MGL_EncodingUtils {
    private static final Logger logger = LoggerFactory.getLogger(MGL_EncodingUtils.class);

    public static String detectEncodingFromText(String text) {
        CharsetDetector detector = new CharsetDetector();
        detector.setText(text.getBytes());
        CharsetMatch match = detector.detect();
        logger.info("");
        return match != null ? match.getName() : "Unknown";
    }

    public static String detectEncodingFromFile(String filePath) {
        try {
            byte[] data = Files.readAllBytes(Paths.get(filePath, new String[0]));
            CharsetDetector detector = new CharsetDetector();
            detector.setText(data);
            CharsetMatch match = detector.detect();
            return match != null ? match.getName() : "Unknown";
        }
        catch (IOException e) {
            logger.warn(e.getMessage());
            return "Unknown";
        }
    }

    public static void main(String[] args) {
        System.out.println(MGL_EncodingUtils.detectEncodingFromText("src/test/resources/mgl_encoding.txt"));
    }
}

