/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.utils;

import jakarta.servlet.http.HttpServletResponse;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import tech.mgl.core.utils.MGL_StringUtils;
import tech.mgl.utils.MGL_FileNameUtils;

public class MGL_DownloadHeaderBuilder {
    private final HttpServletResponse response;
    private String fileName;
    private Long fileSize;
    private String contentType = "application/octet-stream";
    private Charset encoding = Charset.forName("ISO8859-1");

    private MGL_DownloadHeaderBuilder(HttpServletResponse response) {
        this.response = response;
    }

    public static MGL_DownloadHeaderBuilder create(HttpServletResponse response) {
        return new MGL_DownloadHeaderBuilder(response);
    }

    public MGL_DownloadHeaderBuilder fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public MGL_DownloadHeaderBuilder fileSize(Long fileSize) {
        this.fileSize = fileSize;
        return this;
    }

    public MGL_DownloadHeaderBuilder contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public MGL_DownloadHeaderBuilder encoding(Charset encoding) {
        this.encoding = encoding;
        return this;
    }

    public void build() {
        String tempName = new String(this.fileName.getBytes(this.encoding), this.encoding);
        this.response.setContentType(this.contentType + "; charset=" + this.encoding.name());
        this.response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(tempName + (MGL_StringUtils.isBlank((CharSequence)MGL_FileNameUtils.getExtension(this.fileName)) ? ".xlsx" : ""), this.encoding));
        this.response.addHeader("Pragma", "no-cache");
        this.response.addHeader("Cache-Control", "no-cache");
        this.response.setDateHeader("Expires", 0L);
        if (this.fileSize != null) {
            this.response.setContentLengthLong(this.fileSize.longValue());
        }
    }
}

