/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import tech.mgl.core.i.BeanMapConverter;
import tech.mgl.core.i.impl.JacksonBeanMapConverter;
import tech.mgl.core.i.impl.PureJavaBeanMapConverter;
import tech.mgl.core.i.test.Test1;
import tech.mgl.core.utils.MGL_BeanUtils;
import tech.mgl.expand.MGL_SpringUtils;

public class MGL_BeanMapUtils {
    private static final Logger logger = LoggerFactory.getLogger(MGL_BeanMapUtils.class);
    private static BeanMapConverter converter;

    private static void initializeConverter() {
        ServiceLoader<BeanMapConverter> loader = ServiceLoader.load(BeanMapConverter.class);
        ObjectMapper objectMapper = MGL_BeanMapUtils.getObjectMapper();
        Optional<ObjectMapper> optionalObjectMapper = Optional.ofNullable(objectMapper);
        BeanMapConverter selectedConverter = null;
        if (optionalObjectMapper.isPresent()) {
            selectedConverter = new JacksonBeanMapConverter(optionalObjectMapper.get());
        }
        for (BeanMapConverter availableConverter : loader) {
            System.out.println("availableConverter::" + availableConverter.getClass().getName());
            if (availableConverter instanceof JacksonBeanMapConverter && optionalObjectMapper.isPresent()) {
                selectedConverter = new JacksonBeanMapConverter(optionalObjectMapper.get());
                break;
            }
            selectedConverter = availableConverter;
        }
        if (selectedConverter != null) {
            System.out.println("selectedConverter:" + selectedConverter.getClass().getName());
        }
        System.out.println(loader.stream().count() + "==" + loader.stream().findAny().isEmpty());
        if (selectedConverter == null || loader.stream().count() > 1L) {
            System.out.println("loader.stream().count():: " + loader.stream().count());
            converter = loader.stream().map(ServiceLoader.Provider::get).max(Comparator.comparingInt(BeanMapConverter::getPriority)).orElse(new PureJavaBeanMapConverter());
        } else {
            converter = selectedConverter;
        }
        logger.info("BeanMapConverter initialized, converter: {}", (Object)converter.getClass().getName());
    }

    private static ObjectMapper getObjectMapper() {
        try {
            Class<?> contextClass = Class.forName("org.springframework.context.ApplicationContext");
            Class<?> holderClass = Class.forName("org.springframework.web.context.ContextLoader");
            Object context = holderClass.getMethod("getCurrentWebApplicationContext", new Class[0]).invoke(null, new Object[0]);
            System.out.println("is emty " + (context == null ? "null" : context.getClass().getName()));
            if (context != null) {
                System.out.println("get ObjectMapper ok ");
                return (ObjectMapper)((ApplicationContext)context).getBean(ObjectMapper.class);
            }
            System.out.println("get ObjectMapper ok other");
            return MGL_SpringUtils.getBean(ObjectMapper.class);
        }
        catch (Exception e) {
            logger.warn("It looks like it's not a Spring Boot environment., {}", (Object)e.getMessage());
            return null;
        }
    }

    public static <T> T mapToBean(Map<String, Object> map, Class<T> beanClass) {
        return converter.mapToBean(map, beanClass);
    }

    public static Map<?, ?> beanToMap(Object bean) {
        return converter.beanToMap(bean);
    }

    public static void main(String[] args) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", "value1");
        map.put("name", "value1");
        Test1 test1 = MGL_BeanMapUtils.mapToBean(map, Test1.class);
        Test1 test2 = MGL_BeanUtils.map2Bean(map, Test1.class);
        System.out.println(test1.getId());
        System.out.println(test2.getId());
    }

    static {
        MGL_BeanMapUtils.initializeConverter();
    }
}

