/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils.security;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import tech.mgl.core.utils.MGL_StringUtils;

public class MGL_URLUtils {
    private static final String ENCODE = "UTF-8";
    private static final String CIPHER_ALGORITHM = "AES";
    private static final String KEY_ALGORITHM = "AES";
    private static final String PASSWORD_HASH_ALGORITHM = "SHA-256";

    public static synchronized String crypt(String content, String keyStr, CryptType ty) throws Exception {
        KeyGenerator generator = KeyGenerator.getInstance("AES");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.setSeed(MGL_URLUtils.build3DesKey(keyStr));
        generator.init(128, random);
        SecretKey skey = generator.generateKey();
        byte[] raw = skey.getEncoded();
        SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
        generator = null;
        if (ty == null || ty == CryptType.EN) {
            return MGL_URLUtils.getEncString(content, skeySpec);
        }
        return MGL_URLUtils.getDesString(content, skeySpec);
    }

    public static byte[] build3DesKey(String keyStr) throws UnsupportedEncodingException {
        byte[] key = new byte[24];
        byte[] temp = keyStr.getBytes(ENCODE);
        if (key.length > temp.length) {
            System.arraycopy(temp, 0, key, 0, temp.length);
        } else {
            System.arraycopy(temp, 0, key, 0, key.length);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getEncString(String strMing, Key key) {
        byte[] byteMi = null;
        byte[] byteMing = null;
        String strMi = "";
        Base64.Encoder base64en = Base64.getEncoder();
        try {
            byteMing = strMing.getBytes(ENCODE);
            byteMi = MGL_URLUtils.getEncCode(byteMing, key);
            strMi = base64en.encodeToString(byteMi);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            base64en = null;
            byteMing = null;
            byteMi = null;
        }
        return strMi;
    }

    private static String getDesString(String strMi, Key key) throws Exception {
        Base64.Decoder base64De = Base64.getDecoder();
        byte[] byteMing = null;
        byte[] byteMi = null;
        String strMing = "";
        try {
            byteMi = base64De.decode(strMi);
            byteMing = MGL_URLUtils.getDesCode(byteMi, key);
            strMing = new String(byteMing, ENCODE);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            base64De = null;
            byteMing = null;
            byteMi = null;
        }
        return strMing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getEncCode(byte[] byteS, Key key) {
        byte[] byteFina = null;
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, key);
            byteFina = cipher.doFinal(byteS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Object cipher = null;
        }
        return byteFina;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getDesCode(byte[] byteD, Key key) {
        byte[] byteFina = null;
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, key);
            byteFina = cipher.doFinal(byteD);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Object cipher = null;
        }
        return byteFina;
    }

    public static void main(String[] args) {
        try {
            String em = MGL_URLUtils.crypt("g/_mgl_up/2016/06/IMG_201606088051465397784805zX4K.png1", "a38f6a9ae6650e4d5eeb7a1ee", CryptType.EN);
            System.out.println(em);
            String result = MGL_URLUtils.crypt(em, "a38f6a9ae6650e4d5eeb7a1e", CryptType.DE);
            System.out.println(result);
            System.out.println(MGL_URLUtils.getQueryParameters("https://baidu.com?name=test&name=test1&age=10"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<String> getQueryParameter(String url, String key) throws URISyntaxException {
        return Objects.requireNonNull(MGL_URLUtils.getQueryParameters(url, key)).get(key);
    }

    public static Map<String, List<String>> splitQuery(String query, String useKey) {
        String[] pairs;
        HashMap<String, List<String>> queryPairs = new HashMap<String, List<String>>();
        for (String pair : pairs = query.split("&")) {
            int idx = pair.indexOf("=");
            String key = URLDecoder.decode(pair.substring(0, idx), StandardCharsets.UTF_8);
            if (MGL_StringUtils.isNotBlank((CharSequence)useKey) && !key.equals(useKey)) continue;
            String value = URLDecoder.decode(pair.substring(idx + 1), StandardCharsets.UTF_8);
            queryPairs.computeIfAbsent(key, k -> new ArrayList()).add(value);
        }
        return queryPairs;
    }

    public static Map<String, List<String>> getQueryParameters(String url) throws URISyntaxException {
        return MGL_URLUtils.getQueryParameters(url, null);
    }

    public static Map<String, List<String>> getQueryParameters(String url, String ky) throws URISyntaxException {
        URI uri = new URI(url);
        String query = uri.getQuery();
        if (query == null || query.isEmpty()) {
            return new HashMap<String, List<String>>();
        }
        return MGL_URLUtils.splitQuery(query, ky);
    }

    public static enum CryptType {
        EN,
        DE;

    }
}

