/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils.security;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class MGL_Rfc2898DeriveBytes {
    private static final int BLOCK_SIZE = 20;
    private static final SecureRandom random = new SecureRandom();
    private final Mac hmacSha1;
    private final byte[] salt;
    private final int iterations;
    private byte[] buffer = new byte[20];
    private int startIndex = 0;
    private int endIndex = 0;
    private int block = 1;

    public MGL_Rfc2898DeriveBytes(byte[] password, byte[] salt, int iterations) throws NoSuchAlgorithmException, InvalidKeyException {
        this.salt = salt;
        this.iterations = iterations;
        this.hmacSha1 = Mac.getInstance("HmacSHA1");
        this.hmacSha1.init(new SecretKeySpec(password, "HmacSHA1"));
    }

    public MGL_Rfc2898DeriveBytes(String password, int saltSize, int iterations) throws NoSuchAlgorithmException, InvalidKeyException {
        this.salt = MGL_Rfc2898DeriveBytes.randomSalt(saltSize);
        this.iterations = iterations;
        this.hmacSha1 = Mac.getInstance("HmacSHA1");
        this.hmacSha1.init(new SecretKeySpec(password.getBytes(StandardCharsets.UTF_8), "HmacSHA1"));
        this.buffer = new byte[20];
        this.block = 1;
        this.endIndex = 1;
        this.startIndex = 1;
    }

    public MGL_Rfc2898DeriveBytes(String password, int saltSize) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        this(password, saltSize, 1000);
    }

    public MGL_Rfc2898DeriveBytes(String password, byte[] salt, int iterations) throws InvalidKeyException, NoSuchAlgorithmException, UnsupportedEncodingException {
        this(password.getBytes(StandardCharsets.UTF_8), salt, iterations);
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public String getSaltAsString() {
        return Base64.getEncoder().encodeToString(this.salt);
    }

    public byte[] getBytes(int cb) {
        byte[] result = new byte[cb];
        int offset = 0;
        int size = this.endIndex - this.startIndex;
        if (size > 0) {
            if (cb >= size) {
                System.arraycopy(this.buffer, this.startIndex, result, 0, size);
                this.endIndex = 0;
                this.startIndex = 0;
                offset += size;
            } else {
                System.arraycopy(this.buffer, this.startIndex, result, 0, cb);
                this.startIndex += cb;
                return result;
            }
        }
        while (offset < cb) {
            byte[] block = this.func();
            int remainder = cb - offset;
            if (remainder > 20) {
                System.arraycopy(block, 0, result, offset, 20);
                offset += 20;
                continue;
            }
            System.arraycopy(block, 0, result, offset, remainder);
            offset += remainder;
            System.arraycopy(block, remainder, this.buffer, this.startIndex, 20 - remainder);
            this.endIndex += 20 - remainder;
            return result;
        }
        return result;
    }

    public static byte[] randomSalt(int size) {
        byte[] salt = new byte[size];
        random.nextBytes(salt);
        return salt;
    }

    public static String generateSalt(int size) {
        byte[] salt = MGL_Rfc2898DeriveBytes.randomSalt(size);
        return Base64.getEncoder().encodeToString(salt);
    }

    private byte[] func() {
        this.hmacSha1.update(this.salt, 0, this.salt.length);
        byte[] tempHash = this.hmacSha1.doFinal(MGL_Rfc2898DeriveBytes.getBytesFromInt(this.block));
        this.hmacSha1.reset();
        byte[] finalHash = tempHash;
        for (int i = 2; i <= this.iterations; ++i) {
            tempHash = this.hmacSha1.doFinal(tempHash);
            for (int j = 0; j < 20; ++j) {
                finalHash[j] = (byte)(finalHash[j] ^ tempHash[j]);
            }
        }
        this.block = this.block == Integer.MAX_VALUE ? Integer.MIN_VALUE : ++this.block;
        return finalHash;
    }

    private static byte[] getBytesFromInt(int i) {
        return new byte[]{(byte)(i >>> 24), (byte)(i >>> 16), (byte)(i >>> 8), (byte)i};
    }
}

