/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils.security;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.core.qrcode.MGL_QRCodeUtils;
import tech.mgl.core.utils.security.MGL_OTPBuilder;

public class MGL_OTP {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
    private final int SECRET_SIZE = 20;
    private final String SEED = "g8GsldkjglElDe98545863=c?.csw5rbKFI7izOF8GwLDVKs2m0QN7vxRs2im5MDaNCWGmcD2rvcZx";
    private final String RANDOM_NUMBER_ALGORITHM = "SHA1PRNG";
    private int offset = 3;
    private final String account;
    private final String issuer;
    private final String secretKey;
    private final String code;

    public String getCode() {
        return this.code;
    }

    public String getAccount() {
        return this.account;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public MGL_OTP(MGL_OTPBuilder builder) {
        this.account = builder.getAccount();
        this.issuer = builder.getIssuer();
        this.secretKey = builder.getSecretKey();
        this.code = builder.getCode();
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        if (offset >= 3 && offset <= 17) {
            this.offset = offset;
        }
    }

    public Boolean authCode(String codes, String savedSecret) {
        long code = Long.parseLong(codes);
        long t = System.currentTimeMillis();
        this.setOffset(0);
        return this.checkCode(savedSecret, code, t);
    }

    public Boolean authCode(String codes) {
        return this.authCode(codes, this.getSecretKey());
    }

    public Boolean authCode() {
        return this.authCode(this.getCode(), this.getSecretKey());
    }

    public String generateSecretKey() {
        try {
            SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
            sr.setSeed(Base64.decodeBase64((String)"g8GsldkjglElDe98545863=c?.csw5rbKFI7izOF8GwLDVKs2m0QN7vxRs2im5MDaNCWGmcD2rvcZx"));
            byte[] buffer = sr.generateSeed(20);
            Base32 codec = new Base32();
            return codec.encodeToString(buffer);
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getQRBarcodeURL(String user, String host, String secret) {
        String format = "https://www.google.com/chart?chs=200x200&chld=M%%7C0&cht=qr&chl=otpauth://totp/%s@%s%%3Fsecret%%3D%s";
        return String.format(format, user, host, secret);
    }

    public String getGoogleAuthenticatorBarCode() {
        return "otpauth://totp/" + URLEncoder.encode(this.issuer + ":" + this.account, StandardCharsets.UTF_8).replace("+", "%20") + "?secret=" + URLEncoder.encode(this.secretKey, StandardCharsets.UTF_8).replace("+", "%20") + "&issuer=" + URLEncoder.encode(this.issuer, StandardCharsets.UTF_8).replace("+", "%20");
    }

    public void createQRCode(String barCodeData, String filePath, int height, int width) throws WriterException, IOException {
        BitMatrix matrix = new MultiFormatWriter().encode(barCodeData, BarcodeFormat.QR_CODE, width, height);
        try (FileOutputStream out = new FileOutputStream(filePath);){
            MatrixToImageWriter.writeToStream((BitMatrix)matrix, (String)"png", (OutputStream)out);
        }
    }

    public void qrcode() throws Exception {
        MGL_QRCodeUtils utils = MGL_QRCodeUtils.builder().setContent(this.getGoogleAuthenticatorBarCode()).build();
        utils.encode();
    }

    private boolean checkCode(String secretKey, long code, long timeMsec) {
        Base32 codec = new Base32();
        byte[] decodedKey = codec.decode(secretKey);
        long t = timeMsec / 1000L / 30L;
        for (int i = -this.offset; i <= this.offset; ++i) {
            long hash;
            try {
                hash = this.verify_code(decodedKey, t + (long)i);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
            if (hash != code) continue;
            return true;
        }
        return false;
    }

    private int verify_code(byte[] key, long t) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] data = new byte[8];
        long value = t;
        int i = 8;
        while (i-- > 0) {
            data[i] = (byte)value;
            value >>>= 8;
        }
        SecretKeySpec signKey = new SecretKeySpec(key, "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(signKey);
        byte[] hash = mac.doFinal(data);
        int offset = hash[19] & 0xF;
        long truncatedHash = 0L;
        for (int i2 = 0; i2 < 4; ++i2) {
            truncatedHash <<= 8;
            truncatedHash |= (long)(hash[offset + i2] & 0xFF);
        }
        truncatedHash &= Integer.MAX_VALUE;
        return (int)(truncatedHash %= 1000000L);
    }
}

