/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils.security;

import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.core.utils.security.MGL_Rfc2898DeriveBytes;

public class MGL_CryptoUtils {
    private static final Logger logger = LoggerFactory.getLogger(MGL_CryptoUtils.class);
    private static final int saltSize = 32;
    private static final int iterations = 1000;
    private static final int subKeySize = 32;

    public static String getSalt() {
        return MGL_Rfc2898DeriveBytes.generateSalt(32);
    }

    public static String getHash(String password, String salt) {
        MGL_Rfc2898DeriveBytes keyGenerator = null;
        try {
            keyGenerator = new MGL_Rfc2898DeriveBytes(password + salt, 32, 1000);
        }
        catch (Exception e1) {
            logger.error("get hash exception : {}", (Object)e1.getMessage());
        }
        assert (keyGenerator != null);
        byte[] subKey = keyGenerator.getBytes(32);
        byte[] bSalt = keyGenerator.getSalt();
        byte[] hashPassword = new byte[65];
        System.arraycopy(bSalt, 0, hashPassword, 1, 32);
        System.arraycopy(subKey, 0, hashPassword, 33, 32);
        return Base64.getEncoder().encodeToString(hashPassword);
    }

    public static boolean verify(String hashedPassword, String password, String salt) {
        byte[] hashedPasswordBytes = Base64.getDecoder().decode(hashedPassword);
        if (hashedPasswordBytes.length != 65 || hashedPasswordBytes[0] != 0) {
            return false;
        }
        byte[] bSalt = new byte[32];
        System.arraycopy(hashedPasswordBytes, 1, bSalt, 0, 32);
        byte[] storedSubKey = new byte[32];
        System.arraycopy(hashedPasswordBytes, 33, storedSubKey, 0, 32);
        MGL_Rfc2898DeriveBytes deriveBytes = null;
        try {
            deriveBytes = new MGL_Rfc2898DeriveBytes(password + salt, bSalt, 1000);
        }
        catch (Exception e) {
            logger.error("Passwd verify exception: {}", (Object)e.getMessage());
        }
        assert (deriveBytes != null);
        byte[] generatedSubKey = deriveBytes.getBytes(32);
        return MGL_CryptoUtils.byteArraysEqual(storedSubKey, generatedSubKey);
    }

    private static boolean byteArraysEqual(byte[] storedSubKey, byte[] generatedSubKey) {
        int size = storedSubKey.length;
        if (size != generatedSubKey.length) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (storedSubKey[i] == generatedSubKey[i]) continue;
            return false;
        }
        return true;
    }
}

