/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils.img;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class MGL_PicUtils {
    private Font font = new Font("\u534e\u6587\u5f69\u4e91", 0, 40);
    private Graphics2D g = null;
    private int fontsize = 0;
    private int x = 0;
    private int y = 0;

    public BufferedImage loadImageLocal(String imgName) {
        try {
            return ImageIO.read(new File(imgName));
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public BufferedImage loadImageUrl(String imgName) {
        try {
            URL url = new URL(imgName);
            return ImageIO.read(url);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public void writeImageLocal(String newImage, BufferedImage img) {
        if (newImage != null && img != null) {
            try {
                File outputfile = new File(newImage);
                ImageIO.write((RenderedImage)img, "jpg", outputfile);
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    public void setFont(String fontStyle, int fontSize) {
        this.fontsize = fontSize;
        this.font = new Font(fontStyle, 0, fontSize);
    }

    public BufferedImage modifyImage(BufferedImage img, Object content, int x, int y) {
        try {
            int w = img.getWidth();
            int h = img.getHeight();
            this.g = img.createGraphics();
            this.g.setBackground(Color.WHITE);
            this.g.setColor(Color.orange);
            if (this.font != null) {
                this.g.setFont(this.font);
            }
            if (x >= h || y >= w) {
                this.x = h - this.fontsize + 2;
                this.y = w;
            } else {
                this.x = x;
                this.y = y;
            }
            if (content != null) {
                this.g.drawString(content.toString(), this.x, this.y);
            }
            this.g.dispose();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return img;
    }

    public BufferedImage modifyImage(BufferedImage img, Object[] contentArr, int x, int y, boolean xory) {
        try {
            int w = img.getWidth();
            int h = img.getHeight();
            this.g = img.createGraphics();
            this.g.setBackground(Color.WHITE);
            this.g.setColor(Color.RED);
            if (this.font != null) {
                this.g.setFont(this.font);
            }
            if (x >= h || y >= w) {
                this.x = h - this.fontsize + 2;
                this.y = w;
            } else {
                this.x = x;
                this.y = y;
            }
            if (contentArr != null) {
                int arrlen = contentArr.length;
                if (xory) {
                    for (int i = 0; i < arrlen; ++i) {
                        this.g.drawString(contentArr[i].toString(), this.x, this.y);
                        this.x += contentArr[i].toString().length() * this.fontsize / 2 + 5;
                    }
                } else {
                    for (int i = 0; i < arrlen; ++i) {
                        this.g.drawString(contentArr[i].toString(), this.x, this.y);
                        this.y += this.fontsize + 2;
                    }
                }
            }
            this.g.dispose();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return img;
    }

    public BufferedImage modifyImageYe(BufferedImage img) {
        try {
            int w = img.getWidth();
            int h = img.getHeight();
            this.g = img.createGraphics();
            this.g.setBackground(Color.WHITE);
            this.g.setColor(Color.blue);
            if (this.font != null) {
                this.g.setFont(this.font);
            }
            this.g.drawString("www.hi.baidu.com?xia_mingjian", w - 85, h - 5);
            this.g.dispose();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return img;
    }

    public BufferedImage modifyImagetogeter(BufferedImage b, BufferedImage d) {
        try {
            int w = b.getWidth();
            int h = b.getHeight();
            this.g = d.createGraphics();
            this.g.drawImage(b, 100, 10, w, h, null);
            this.g.dispose();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return d;
    }

    public static void main(String[] args) {
        MGL_PicUtils tt = new MGL_PicUtils();
        BufferedImage d = tt.loadImageLocal("G:\\Photos\\4b90f603738da97711476f4eb351f8198618e36f.jpg");
        tt.writeImageLocal("G:\\Photos\\test\\addfont.jpg", tt.modifyImage(d, "\u4e1c\u5c1a\u7eaa\u5143", 90, 90));
        System.out.println("success");
    }
}

