/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils.img;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.compress.utils.FileNameUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.core.utils.MGL_Asserts;
import tech.mgl.core.utils.MGL_Base64Utils;
import tech.mgl.core.utils.img.MGL_ImgVo;
import tech.mgl.utils.MGL_FileNameUtils;

public class MGL_ImageUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MGL_ImageUtils.class);
    private static final List<String> exts = List.of("bmp", "jpg", "png", "tif", "gif", "pcx", "tga", "exif", "fpx", "svg", "psd", "cdr", "pcd", "dxf", "ufo", "eps", "ai", "raw", "WMF", "webp", "avif", "apng");
    private static final HttpClient httpClient = HttpClient.newHttpClient();

    public static synchronized boolean cropImage(String src, String dest, int x, int y, int w, int h) throws IOException {
        BufferedImage bi = ImageIO.read(new File(src));
        BufferedImage b = bi.getSubimage(x, y, w, h);
        boolean result = ImageIO.write((RenderedImage)b, FileNameUtils.getExtension((String)dest), new File(dest));
        b.flush();
        bi.flush();
        return result;
    }

    public static synchronized BufferedImage rotateImage(String srcPath, String destPath, int angel) throws IOException {
        return MGL_ImageUtils.rotateImage(srcPath, destPath, angel, true);
    }

    public static synchronized BufferedImage rotateImage(String srcPath, String destPath, int angel, boolean setTran) throws IOException {
        BufferedImage src = ImageIO.read(new File(srcPath));
        int src_width = src.getWidth(null);
        int src_height = src.getHeight(null);
        if (angel < 0) {
            angel = 360 + angel;
        }
        Rectangle rect_des = MGL_ImageUtils.CalcRotatedSize(new Rectangle(new Dimension(src_width, src_height)), angel);
        BufferedImage res = null;
        res = srcPath.toLowerCase().endsWith(".png") || setTran ? new BufferedImage(rect_des.width, rect_des.height, 3) : new BufferedImage(rect_des.width, rect_des.height, 1);
        Graphics2D g2 = res.createGraphics();
        g2.translate((rect_des.width - src_width) / 2, (rect_des.height - src_height) / 2);
        g2.rotate(Math.toRadians(angel), (double)src_width / 2.0, (double)src_height / 2.0);
        g2.drawImage(src, null, null);
        ImageIO.write((RenderedImage)res, FileNameUtils.getExtension((Path)Paths.get(destPath, new String[0])), new File(destPath));
        res.flush();
        src.flush();
        return res;
    }

    private static Rectangle CalcRotatedSize(Rectangle src, int angel) {
        if (angel >= 90) {
            if (angel / 90 % 2 == 1) {
                int temp = src.height;
                src.height = src.width;
                src.width = temp;
            }
            angel %= 90;
        }
        double r = Math.sqrt(src.height * src.height + src.width * src.width) / 2.0;
        double len = 2.0 * Math.sin(Math.toRadians(angel) / 2.0) * r;
        double angel_alpha = (Math.PI - Math.toRadians(angel)) / 2.0;
        double angel_dalta_width = Math.atan((double)src.height / (double)src.width);
        double angel_dalta_height = Math.atan((double)src.width / (double)src.height);
        int len_dalta_width = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_width));
        int len_dalta_height = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_height));
        int des_width = src.width + len_dalta_width * 2;
        int des_height = src.height + len_dalta_height * 2;
        return new Rectangle(new Dimension(des_width, des_height));
    }

    public static synchronized BufferedImage getTransparentImg(int width, int height) {
        if (width == 0) {
            width = 1024;
        }
        if (height == 0) {
            height = 768;
        }
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g2d = image.createGraphics();
        image = g2d.getDeviceConfiguration().createCompatibleImage(width, height, 3);
        g2d.dispose();
        g2d = image.createGraphics();
        g2d.setColor(new Color(255, 0, 0));
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.drawImage(image, 100, 10, width, height, null);
        g2d.dispose();
        image.flush();
        return image;
    }

    public static synchronized boolean append(List<MGL_ImgVo> inputFileNameList, String outputFileName, int outputW, int outputH) throws Exception {
        if (inputFileNameList == null || inputFileNameList.isEmpty()) {
            return false;
        }
        BufferedImage outputImg = null;
        int outputImgW = Math.max(outputW, 0);
        int outputImgH = Math.max(outputH, 0);
        outputImg = MGL_ImageUtils.getTransparentImg(outputImgW, outputImgH);
        for (MGL_ImgVo vo : inputFileNameList) {
            BufferedImage appendImg = ImageIO.read(new File(vo.getPath()));
            int appendImgW = appendImg.getWidth();
            int appendImgH = appendImg.getHeight();
            appendImgW = appendImgW + vo.getX() > outputImgW ? outputImgW - vo.getX() : appendImgW;
            appendImgH = appendImgH + vo.getY() > outputImgH ? outputImgH - vo.getY() : appendImgH;
            Graphics2D g2d = outputImg.createGraphics();
            Image img = null;
            BufferedImage imageNew = null;
            img = vo.getPath().endsWith(".png") ? appendImg.getScaledInstance(appendImgW, appendImgH, 16) : appendImg.getScaledInstance(appendImgW, appendImgH, 4);
            imageNew = g2d.getDeviceConfiguration().createCompatibleImage(outputImgW, outputImgH, 3);
            g2d.dispose();
            g2d = imageNew.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.drawImage(outputImg, 0, 0, outputImgW, outputImgH, null);
            g2d.drawImage(img, vo.getX(), vo.getY(), appendImgW, appendImgH, null);
            outputImg = imageNew;
            imageNew.flush();
            g2d.dispose();
            img.flush();
        }
        boolean result = MGL_ImageUtils.writeImageLocal(outputFileName, outputImg);
        outputImg.flush();
        return result;
    }

    private static boolean writeImageLocal(String fileName, BufferedImage image) throws IOException {
        if (fileName != null && image != null) {
            File file = new File(fileName);
            boolean result = ImageIO.write((RenderedImage)image, "png", file);
            image.flush();
            fileName = null;
            return result;
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            String netImageToBase64 = MGL_Base64Utils.netImageToBase64("https://img0.baidu.com/it/u=1308773983,1010192299&fm=253&fmt=auto&app=120&f=JPEG?w=667&h=500");
            System.out.println(netImageToBase64);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isImage(String fileName) {
        return exts.contains(MGL_FileNameUtils.getExtension(fileName).toLowerCase());
    }

    public static boolean isImage(String fileName, List<String> ext) {
        return ext.contains(MGL_FileNameUtils.getExtension(fileName).toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isImage(Object obj) throws Exception {
        MGL_Asserts.notEmpty(obj, "Image can not null");
        Object tempObj = obj;
        if (tempObj instanceof String) {
            String path = (String)tempObj;
            tempObj = new File(path);
        }
        if (tempObj instanceof File) {
            File file = (File)tempObj;
            BufferedImage vo = null;
            try {
                if (file.isFile()) {
                    vo = ImageIO.read(file);
                    boolean bl = null != vo;
                    return bl;
                }
            }
            finally {
                if (null != vo) {
                    vo.flush();
                    vo = null;
                }
            }
            return false;
        }
        if (tempObj instanceof URL) {
            URL url = (URL)tempObj;
            BufferedImage vo = null;
            try {
                vo = ImageIO.read(url);
                boolean bl = null != vo;
                return bl;
            }
            finally {
                if (null != vo) {
                    vo.flush();
                    vo = null;
                }
            }
        }
        return false;
    }

    public static byte[] fetchNetImg(String url) throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpGet httpGet = new HttpGet(url);
            httpGet.setHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
            httpGet.setHeader("User-Agent", (Object)"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Safari/537.36");
            HttpClientResponseHandler responseHandler = response -> {
                int statusCode = response.getCode();
                if (statusCode == 200) {
                    HttpEntity entity = response.getEntity();
                    return entity != null ? EntityUtils.toByteArray((HttpEntity)entity) : null;
                }
                throw new IOException("Unexpected response status: " + statusCode + "::" + String.valueOf(response.getEntity().getContent()));
            };
            byte[] byArray = (byte[])httpClient.execute((ClassicHttpRequest)httpGet, responseHandler);
            return byArray;
        }
    }

    public static void downloadImage(String imageUrl, String savePath) {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(imageUrl)).GET().timeout(Duration.ofSeconds(10L)).header("User-Agent", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/132.0.0.0 Safari/537.36").build();
            HttpResponse<InputStream> response = httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
            if (response.statusCode() != 200) {
                throw new IOException("Failed to download image, HTTP response code: " + response.statusCode());
            }
            try (InputStream inputStream = response.body();
                 FileOutputStream outputStream = new FileOutputStream(savePath);){
                inputStream.transferTo(outputStream);
            }
            System.out.println("\u56fe\u7247\u5df2\u6210\u529f\u4e0b\u8f7d\u5230 " + savePath);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
        }
    }
}

