/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils.id;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.core.utils.MGL_PropUtils;
import tech.mgl.core.utils.id.MGL_SnowflakeIdGenerator;

public class MGL_SnowflakeIdGeneratorInstance {
    private static final Logger logger = LoggerFactory.getLogger(MGL_SnowflakeIdGeneratorInstance.class);
    private static final Map<String, MGL_SnowflakeIdGenerator> instance = new HashMap<String, MGL_SnowflakeIdGenerator>(0);
    private static int day = -1;
    private static String defaultWorkerId = "1";
    private static String defaultDataCenterId = "1";
    private static String defaultStartTime = String.valueOf(System.currentTimeMillis());

    public static synchronized MGL_SnowflakeIdGenerator getInstance(long workerId, long dataCenterId, boolean newStartTime) {
        if (!newStartTime) {
            return MGL_SnowflakeIdGeneratorInstance.getInstance(workerId, dataCenterId);
        }
        String key = workerId + "_" + dataCenterId;
        int curDay = Calendar.getInstance().get(6);
        long sTime = Long.parseLong(defaultStartTime);
        if (day == -1 || day != curDay) {
            day = curDay;
            sTime = System.currentTimeMillis();
            instance.remove(key);
            System.out.println(day + "------------------------------------");
        }
        if (!instance.containsKey(key)) {
            instance.put(key, new MGL_SnowflakeIdGenerator(workerId, dataCenterId, sTime));
        }
        return instance.get(key);
    }

    public static synchronized void setDefaultSnowIdProperties(long workerId, long dataCenterId, long startTime) {
        defaultWorkerId = String.valueOf(workerId);
        defaultDataCenterId = String.valueOf(dataCenterId);
        defaultStartTime = String.valueOf(startTime);
    }

    public static synchronized MGL_SnowflakeIdGenerator getInstance(long workerId, long dataCenterId, long startTime) {
        String key = workerId + "_" + dataCenterId;
        if (!instance.containsKey(key)) {
            instance.put(key, new MGL_SnowflakeIdGenerator(workerId, dataCenterId, startTime));
        }
        return instance.get(key);
    }

    public static synchronized MGL_SnowflakeIdGenerator getInstance(long workerId, long dataCenterId) {
        String key = workerId + "_" + dataCenterId;
        if (!instance.containsKey(key)) {
            instance.put(key, new MGL_SnowflakeIdGenerator(workerId, dataCenterId));
        }
        return instance.get(key);
    }

    public static synchronized MGL_SnowflakeIdGenerator getInstance() {
        String key = defaultWorkerId.concat("_").concat(defaultDataCenterId);
        logger.info("defaultWorkerId: {}, defaultDataCenterId: {}", (Object)defaultWorkerId, (Object)defaultDataCenterId);
        if (!instance.containsKey(key)) {
            instance.put(key, new MGL_SnowflakeIdGenerator(Long.parseLong(defaultWorkerId), Long.parseLong(defaultDataCenterId), Long.parseLong(defaultStartTime)));
        }
        return instance.get(key);
    }

    static {
        try {
            defaultWorkerId = MGL_PropUtils.getVal("mgl.id.worker", "g-conf");
            defaultDataCenterId = MGL_PropUtils.getVal("mgl.id.data-center", "g-conf");
            defaultStartTime = MGL_PropUtils.getVal("mgl.id.start-time", "g-conf");
        }
        catch (Exception e) {
            logger.warn("{} worker datacenterid starttime not set , use default setting", (Object)e.getMessage());
        }
    }
}

