/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils.id;

import java.text.SimpleDateFormat;

public class MGL_SnowflakeIdGenerator {
    private long startTime = System.currentTimeMillis();
    private final long workerIdBits = 5L;
    private final long dataCenterIdBits = 5L;
    private final long sequenceBits = 12L;
    private long workerId;
    private long dataCenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");

    public MGL_SnowflakeIdGenerator(long workerId, long dataCenterId) {
        long maxWorkerId = 31L;
        if (workerId > maxWorkerId || workerId < 0L) {
            throw new IllegalArgumentException(String.format("Worker Id can't be greater than %d or less than 0", maxWorkerId));
        }
        long maxDataCenterId = 31L;
        if (dataCenterId > maxDataCenterId || dataCenterId < 0L) {
            throw new IllegalArgumentException(String.format("DataCenter Id can't be greater than %d or less than 0", maxDataCenterId));
        }
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
    }

    public MGL_SnowflakeIdGenerator(long workerId, long dataCenterId, long startTime) {
        this(workerId, dataCenterId);
        this.startTime = startTime;
    }

    public MGL_SnowflakeIdGenerator() {
    }

    public synchronized long nextId(boolean newIdEveryDay) {
        return newIdEveryDay ? this.nextId() : this.nextId();
    }

    public synchronized long nextId() {
        long timestamp = this.currentTime();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            long sequenceMask = 4095L;
            this.sequence = this.sequence + 1L & sequenceMask;
            if (this.sequence == 0L) {
                timestamp = this.blockTillNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        long dataCenterIdMoveBits = 17L;
        long timestampMoveBits = 22L;
        return timestamp - this.startTime << (int)timestampMoveBits | this.dataCenterId << (int)dataCenterIdMoveBits | this.workerId << 12 | this.sequence;
    }

    private long blockTillNextMillis(long lastTimestamp) {
        long timestamp = this.currentTime();
        while (timestamp <= lastTimestamp) {
            timestamp = this.currentTime();
        }
        return timestamp;
    }

    private long currentTime() {
        return System.currentTimeMillis();
    }
}

