/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils.captcha;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tech.mgl.core.utils.MGL_RandomUtils;
import tech.mgl.core.utils.captcha.MGL_Captcha;
import tech.mgl.core.utils.captcha.MGL_CaptchaConstants;

public class MGL_CaptchaUtils {
    public static synchronized Map<String, Object> getCodeMultiple() {
        int i = MGL_RandomUtils.getRandomNum(0, 5);
        HashMap<String, Object> map = new HashMap<String, Object>(0);
        if (i == 4) {
            String code = MGL_CaptchaUtils.getCode(MGL_Captcha.builder().setLevel(MGL_Captcha.SecurityCodeLevel.random()).setLength(4).build());
            map.put(Keys.code.name(), code);
            map.put(Keys.result.name(), code);
            return map;
        }
        int x1 = MGL_RandomUtils.getRandomNum(0, 20);
        int x2 = MGL_RandomUtils.getRandomNum(0, 10);
        List<Integer> list = Arrays.asList(x1, x2);
        list.sort(Comparator.reverseOrder());
        x1 = list.get(0);
        x2 = list.get(1);
        String[] mathType = MGL_CaptchaConstants.mathTypes.get(i);
        map.put(Keys.code.name(), String.format("%s %s %s = ?", x1, mathType[MGL_RandomUtils.getRandomNum(0, mathType.length)], x2));
        switch (i) {
            case 0: {
                map.put(Keys.result.name(), x1 + x2);
                break;
            }
            case 1: {
                map.put(Keys.result.name(), x1 - x2);
                break;
            }
            case 2: {
                map.put(Keys.result.name(), x1 * x2);
                break;
            }
            case 3: {
                if (x1 == 0) {
                    x1 = 1;
                }
                if (x2 == 0) {
                    x2 = MGL_CaptchaUtils.getX2(map, x2);
                }
                if (x1 < x2) {
                    x1 ^= x2;
                    x2 ^= x1;
                    x1 ^= x2;
                }
                if (x1 % x2 != 0) {
                    x1 = MGL_CaptchaUtils.getX1(map, x1, x2);
                }
                map.put(Keys.result.name(), x1 / x2);
                break;
            }
        }
        return map;
    }

    private static int getX2(Map<String, Object> map, int x2) {
        String o = map.get(Keys.code.name()).toString();
        int tempX2 = x2;
        x2 = 1;
        map.put(Keys.code.name(), o.replace("" + tempX2, "" + x2));
        return x2;
    }

    private static int getX1(Map<String, Object> map, int x1, int x2) {
        String o = map.get(Keys.code.name()).toString();
        int tempX1 = x1;
        x1 -= x1 % x2;
        map.put(Keys.code.name(), o.replace("" + tempX1, "" + x1));
        return x1;
    }

    public static String getCode() {
        return MGL_CaptchaUtils.getCode(MGL_Captcha.builder().build());
    }

    public static String getCode(MGL_Captcha captcha) {
        int level = switch (captcha.getLevel()) {
            default -> throw new MatchException(null, null);
            case MGL_Captcha.SecurityCodeLevel.Simple -> 0;
            case MGL_Captcha.SecurityCodeLevel.Medium -> MGL_RandomUtils.getRandomNum(0, 4);
            case MGL_Captcha.SecurityCodeLevel.Hard -> 5;
        };
        return MGL_RandomUtils.generateCode(captcha.getLength(), level, false);
    }

    public static enum Keys {
        result,
        code;

    }
}

