/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils.captcha;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import java.util.random.RandomGenerator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.core.utils.MGL_Base64Utils;
import tech.mgl.core.utils.MGL_FileIOUtils;

public class MGL_CaptchaImageGenerator {
    private static final Logger log = LoggerFactory.getLogger(MGL_CaptchaImageGenerator.class);
    private final int width;
    private final int height;
    private File fontF = null;
    private static MGL_CaptchaImageGenerator igcr = new MGL_CaptchaImageGenerator();
    private final String VERIFY_CODES = "23456789ABCDEFGHJKLMNPQRSTUVWXYZ";
    private final RandomGenerator random = RandomGenerator.getDefault();

    public static synchronized MGL_CaptchaImageGenerator getInstance() {
        return igcr != null ? igcr : (igcr = new MGL_CaptchaImageGenerator());
    }

    private MGL_CaptchaImageGenerator() {
        this(120, 40);
        log.info(" new ImageGenerator ..... ");
        try {
            this.fontF = MGL_FileIOUtils.copyFileFromJar("/fonts/captcha.ttf");
            if (this.fontF.exists()) {
                Font dynamicFont = Font.createFont(0, this.fontF);
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                ge.registerFont(dynamicFont);
                log.info("\u5b57\u4f53 ({}) \u6ce8\u518c\u6210\u529f", (Object)this.fontF.getAbsolutePath());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private MGL_CaptchaImageGenerator(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public byte[] imageToBytes(BufferedImage image, String format) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, format, out);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return out.toByteArray();
    }

    public Image bytesToImage(byte[] bytes) {
        Image image = Toolkit.getDefaultToolkit().createImage(bytes);
        try {
            MediaTracker mt = new MediaTracker(new Label());
            mt.addImage(image, 0);
            mt.waitForAll();
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return image;
    }

    public String toBase64Image(String userCode) {
        return MGL_Base64Utils.imageToBase64(this.toImage(userCode));
    }

    public BufferedImage toImage(String userCode) {
        try {
            int verifySize = userCode.length();
            BufferedImage image = new BufferedImage(this.width, this.height, 1);
            Random rand = new Random();
            Graphics2D g2 = image.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color[] colors = new Color[5];
            Color[] colorSpaces = new Color[]{Color.WHITE, Color.CYAN, Color.GRAY, Color.LIGHT_GRAY, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.YELLOW};
            float[] fractions = new float[colors.length];
            for (int i = 0; i < colors.length; ++i) {
                colors[i] = colorSpaces[rand.nextInt(colorSpaces.length)];
                fractions[i] = rand.nextFloat();
            }
            Arrays.sort(fractions);
            g2.setColor(Color.GRAY);
            g2.fillRect(0, 0, this.width, this.height);
            Color c = this.getRandColor(200, 250);
            g2.setColor(c);
            g2.fillRect(0, 2, this.width, this.height - 4);
            Random random = new Random();
            g2.setColor(this.getRandColor(160, 200));
            for (int i = 0; i < 20; ++i) {
                int x = random.nextInt(this.width - 1);
                int y = random.nextInt(this.height - 1);
                int xl = random.nextInt(6) + 1;
                int yl = random.nextInt(12) + 1;
                g2.drawLine(x, y, x + xl + 40, y + yl + 20);
            }
            float yawpRate = 0.05f;
            int area = (int)(yawpRate * (float)this.width * (float)this.height);
            for (int i = 0; i < area; ++i) {
                int x = random.nextInt(this.width);
                int y = random.nextInt(this.height);
                int rgb = this.getRandomIntColor();
                image.setRGB(x, y, rgb);
            }
            this.shear(g2, this.width, this.height, c);
            g2.setColor(this.getRandColor(100, 160));
            int fontSize = this.height - 4;
            Font font = new Font("Algerian", 1, fontSize - 4);
            g2.setFont(font);
            char[] chars = userCode.toCharArray();
            for (int i = 0; i < verifySize; ++i) {
                String ch = String.valueOf(chars[i]);
                AffineTransform affine = new AffineTransform();
                affine.setToRotation(0.7853981633974483 * rand.nextDouble() * (double)(rand.nextBoolean() ? 1 : -1), (double)this.width / (double)verifySize * (double)i + (double)fontSize / 2.0, (double)this.height / 2.0);
                g2.setTransform(affine);
                if (this.isChinese(ch)) {
                    if (this.fontF != null && this.fontF.exists()) {
                        Font dynamicFont = Font.createFont(0, this.fontF);
                        Font font1 = dynamicFont.deriveFont((float)fontSize - 8.0f);
                        g2.setFont(font1);
                        g2.setColor(this.getRandColor(10, 200));
                    } else {
                        g2.setColor(this.getRandColor(10, 200));
                        font = new Font("\u9ed1\u4f53,\u5fae\u8f6f\u96c5\u9ed1", 1, fontSize - 4);
                        g2.setFont(font);
                    }
                } else {
                    g2.setColor(this.getRandColor(10, 200));
                    font = new Font("Algerian", 1, fontSize - 4);
                    g2.setFont(font);
                }
                g2.drawChars(chars, i, 1, (this.width - 10) / verifySize * i + 5, this.height / 2 + fontSize / 2 - 10);
            }
            g2.dispose();
            return image;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isChinese(String str) {
        String regEx = "[\u4e00-\u9fa5]";
        Pattern pat = Pattern.compile(regEx);
        Matcher matcher = pat.matcher(str);
        return matcher.find();
    }

    public String getCaptchaCode(int verifySize) {
        return this.getCaptchaCode(verifySize, "23456789ABCDEFGHJKLMNPQRSTUVWXYZ");
    }

    public String getCaptchaCode(int verifySize, String sources) {
        if (sources == null || sources.isEmpty()) {
            sources = "23456789ABCDEFGHJKLMNPQRSTUVWXYZ";
        }
        int codesLen = sources.length();
        RandomGenerator rand = RandomGenerator.getDefault();
        StringBuilder verifyCode = new StringBuilder(verifySize);
        for (int i = 0; i < verifySize; ++i) {
            verifyCode.append(sources.charAt(rand.nextInt(codesLen - 1)));
        }
        return verifyCode.toString();
    }

    private Color getRandColor(int fc, int bc) {
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + this.random.nextInt(bc - fc);
        int g = fc + this.random.nextInt(bc - fc);
        int b = fc + this.random.nextInt(bc - fc);
        return new Color(r, g, b);
    }

    private int getRandomIntColor() {
        int[] rgb = this.getRandomRgb();
        int color = 0;
        for (int c : rgb) {
            color <<= 8;
            color |= c;
        }
        return color;
    }

    private int[] getRandomRgb() {
        int[] rgb = new int[3];
        for (int i = 0; i < 3; ++i) {
            rgb[i] = this.random.nextInt(255);
        }
        return rgb;
    }

    private void shear(Graphics g, int w1, int h1, Color color) {
        this.shearX(g, w1, h1, color);
        this.shearY(g, w1, h1, color);
    }

    private void shearX(Graphics g, int w1, int h1, Color color) {
        int period = this.random.nextInt(2);
        boolean borderGap = true;
        boolean frames = true;
        int phase = this.random.nextInt(2);
        for (int i = 0; i < h1; ++i) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
            g.copyArea(0, i, w1, 1, (int)d, 0);
            g.setColor(color);
            g.drawLine((int)d, i, 0, i);
            g.drawLine((int)d + w1, i, w1, i);
        }
    }

    private void shearY(Graphics g, int w1, int h1, Color color) {
        int period = this.random.nextInt(40) + 10;
        boolean borderGap = true;
        int frames = 20;
        int phase = 7;
        for (int i = 0; i < w1; ++i) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
            g.copyArea(i, 0, 1, h1, 0, (int)d);
            g.setColor(color);
            g.drawLine(i, (int)d, i, 0);
            g.drawLine(i, (int)d + h1, i, h1);
        }
    }
}

