/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils.captcha;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Hashtable;
import java.util.Random;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.core.utils.MGL_FontUtils;
import tech.mgl.core.utils.MGL_RandomUtils;
import tech.mgl.core.utils.captcha.MGL_Captcha;
import tech.mgl.core.utils.captcha.MGL_CaptchaUtils;
import tech.mgl.core.utils.gif.MGL_AnimatedGifEncoder;
import tech.mgl.core.utils.random.MGL_ColorUtils;

public class MGL_CaptchaImage {
    private final Logger log = LoggerFactory.getLogger(MGL_CaptchaImage.class);
    private static MGL_CaptchaImage captchaCode = null;
    private String verifyCode;
    private final Hashtable<Integer, Integer> pos = new Hashtable();

    private MGL_CaptchaImage() {
        this.log.info(" New VerifyCode ... .");
    }

    public static synchronized MGL_CaptchaImage getInstance() {
        return captchaCode != null ? captchaCode : (captchaCode = new MGL_CaptchaImage());
    }

    public BufferedImage createImage(String securityCode) {
        int codeLength = securityCode.length();
        int fSize = 18;
        int fWidth = fSize + 1;
        int width = codeLength * fWidth + 10;
        int height = fSize * 2 + 1;
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g = image.createGraphics();
        g.setColor(Color.GRAY);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.LIGHT_GRAY);
        g.setFont(new Font("Arial", 1, height - 1));
        g.drawRect(0, 0, width - 1, height - 1);
        Random rand = new Random();
        g.setColor(Color.BLACK);
        for (int i = 0; i < codeLength * 6; ++i) {
            int x = rand.nextInt(width);
            int y = rand.nextInt(height);
            g.drawRect(x, y, 2, 1);
        }
        int codeY = height - new Random().nextInt(13);
        g.setFont(new Font("Georgia", 1, fSize));
        for (int i = 0; i < codeLength; ++i) {
            codeY = height - rand.nextInt(height - fSize);
            ((Graphics)g).drawString(String.valueOf(securityCode.charAt(i)), i * width / codeLength + (width / codeLength - fWidth) / 2, codeY);
        }
        g.dispose();
        return image;
    }

    public ByteArrayInputStream getImage(String securityCode) throws Exception {
        BufferedImage image = this.createImage(securityCode);
        return this.convertImageToStream(image);
    }

    public ByteArrayInputStream convertImageToStream(BufferedImage image) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "jpg", bos);
        byte[] bts = bos.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bts);
        bos.flush();
        bos.close();
        return inputStream;
    }

    private ByteArrayInputStream convertToInputStream(ByteArrayOutputStream bos) {
        ByteArrayInputStream inputStream = null;
        try {
            byte[] bts = bos.toByteArray();
            inputStream = new ByteArrayInputStream(bts);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return inputStream;
    }

    public ByteArrayInputStream getImageWithGif(String code) {
        return this.convertToInputStream(this.getImageWithGifAsOutputStream(code));
    }

    public ByteArrayInputStream getImageWithGif() {
        return this.convertToInputStream(this.getImageWithGifAsOutputStream(""));
    }

    public ByteArrayOutputStream getImageWithGifAsOutputStream(String code) {
        MGL_AnimatedGifEncoder agf = new MGL_AnimatedGifEncoder();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        agf.start(bos);
        agf.setQuality(10);
        agf.setDelay(500);
        agf.setRepeat(0);
        BufferedImage frame = null;
        this.verifyCode = StringUtils.isNotBlank((CharSequence)code) ? code : MGL_CaptchaUtils.getCode(MGL_Captcha.builder().setLevel(MGL_Captcha.SecurityCodeLevel.Medium).build());
        this.log.info("verifyCode:::::::::::::" + this.verifyCode);
        if (!this.pos.isEmpty()) {
            this.pos.clear();
        }
        for (int i = 0; i < this.verifyCode.length(); ++i) {
            frame = this.getImageToGif(null, null, null, this.verifyCode, null, MGL_RandomUtils.getRandomNum(0, 7));
            agf.addFrame(frame);
            frame.flush();
        }
        agf.finish();
        return bos;
    }

    public BufferedImage getImageToGif(Color bgcolor, Color linecolor, Color[] fontcolor, String str, Font[] font, int flag) {
        int i;
        int i2;
        int codeLength = StringUtils.isNotBlank((CharSequence)str) ? str.length() : 0;
        int fontSize = 25;
        int gy = fontSize + 3;
        int to = 18;
        if (font == null) {
            font = new Font[codeLength];
            for (i2 = 0; i2 < codeLength; ++i2) {
                font[i2] = MGL_FontUtils.getRandomFont(fontSize);
            }
        }
        bgcolor = bgcolor != null ? bgcolor : MGL_ColorUtils.getRandomColor();
        linecolor = linecolor != null ? linecolor : MGL_ColorUtils.getRandomColor();
        fontcolor = fontcolor != null ? fontcolor : new Color[codeLength];
        for (i2 = 0; i2 < codeLength; ++i2) {
            fontcolor[i2] = MGL_ColorUtils.getRandomColor(100);
        }
        int width = 100;
        int height = gy + 5;
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g2d = image.createGraphics();
        g2d.setColor(bgcolor);
        g2d.fillRect(0, 0, width, height);
        g2d.setColor(linecolor);
        for (i = 0; i < height / 4; ++i) {
            g2d.drawLine(0, i * 3, width, i * 4);
        }
        for (i = 0; i < width / 4; ++i) {
            g2d.drawLine(i * 3, 0, i * 4, height);
        }
        AlphaComposite ac = AlphaComposite.getInstance(3, 0.2f);
        g2d.setComposite(ac);
        g2d.setFont(new Font("\u96b6\u4e66", 3, 26));
        g2d.setColor(Color.red);
        g2d.drawString("m~g^l", 19, 25);
        AlphaComposite ac3 = null;
        boolean b = this.pos.isEmpty();
        for (int i3 = 0; i3 < codeLength; ++i3) {
            g2d.setFont(font[i3]);
            float alp = this.getAlpha(flag, MGL_RandomUtils.getRandomNum(0, 6));
            ac3 = AlphaComposite.getInstance(5, alp);
            g2d.setComposite(ac3);
            g2d.setColor(fontcolor[i3]);
            int max = 20 * i3;
            int min = max > 0 ? max - 10 : max + 2;
            int s = (int)((double)min + Math.random() * (double)(max - min - 1));
            if (b) {
                this.pos.put(i3, s);
            } else {
                s = this.pos.get(i3);
            }
            g2d.drawString("" + str.charAt(i3), s, fontSize);
        }
        g2d.dispose();
        return image;
    }

    private float getAlpha(int i, int j) {
        if (i + j > 5) {
            return (float)(i + j) * 0.2f - 1.2f;
        }
        return (float)(i + j) * 0.2f;
    }

    public String getVerifyCode() {
        return this.verifyCode;
    }

    public void setVerifyCode(String verifyCode) {
        this.verifyCode = verifyCode;
    }
}

