/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils.captcha;

import tech.mgl.core.utils.MGL_RandomUtils;

public class MGL_Captcha {
    private int length = 4;
    private final Boolean repeat;
    private final SecurityCodeLevel level;

    public MGL_Captcha(Builder builder) {
        this.length = builder.getLength();
        this.repeat = builder.getRepeat();
        this.level = builder.getLevel();
    }

    public int getLength() {
        return this.length;
    }

    public Boolean getRepeat() {
        return this.repeat;
    }

    public SecurityCodeLevel getLevel() {
        return this.level;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int length = 4;
        private Boolean repeat = Boolean.TRUE;
        private SecurityCodeLevel level = SecurityCodeLevel.Simple;

        public int getLength() {
            return this.length;
        }

        public Builder setLength(int length) {
            this.length = length;
            return this;
        }

        public Boolean getRepeat() {
            return this.repeat;
        }

        public Builder setRepeat(Boolean repeat) {
            this.repeat = repeat;
            return this;
        }

        public SecurityCodeLevel getLevel() {
            return this.level;
        }

        public Builder setLevel(SecurityCodeLevel level) {
            this.level = level;
            return this;
        }

        public MGL_Captcha build() {
            return new MGL_Captcha(this);
        }
    }

    public static enum SecurityCodeLevel {
        Simple,
        Medium,
        Hard;


        public static SecurityCodeLevel getLevelByIndex(int i) {
            for (SecurityCodeLevel value : SecurityCodeLevel.values()) {
                if (value.ordinal() != i) continue;
                return value;
            }
            return Simple;
        }

        public static SecurityCodeLevel random() {
            return SecurityCodeLevel.getLevelByIndex(MGL_RandomUtils.getRandomNum(0, SecurityCodeLevel.values().length));
        }
    }
}

