/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils;

import com.alibaba.fastjson2.JSON;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.core.utils.TestModel;

public class MGL_XMLUtils {
    private static final Logger logger = LoggerFactory.getLogger(MGL_XMLUtils.class);

    public static synchronized Map<String, Object> parseToMap(String xml) throws Exception {
        if (StringUtils.isBlank((CharSequence)xml)) {
            return null;
        }
        Document document = DocumentHelper.parseText((String)xml);
        Element els = document.getRootElement();
        List el = els.elements();
        HashMap<String, Object> map = new HashMap<String, Object>(0);
        for (Element e : el) {
            if (!StringUtils.isNotBlank((CharSequence)e.getName())) continue;
            List child = e.elements();
            if (child != null && !child.isEmpty()) {
                MGL_XMLUtils.toMapFor(map, child, e.getName());
                continue;
            }
            map.put(e.getName(), e.getText());
        }
        return map;
    }

    public static synchronized <T> T parseToBean(String xml, Class<T> type) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)xml) && type != null) {
            Document document = DocumentHelper.parseText((String)xml);
            Element els = document.getRootElement();
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            HashMap<String, String> srcName = new HashMap<String, String>(0);
            MGL_XMLUtils.getAllDeclaredFields(srcName, type);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            T tt = type.getConstructor(new Class[0]).newInstance(new Object[0]);
            for (PropertyDescriptor descriptor : propertyDescriptors) {
                String eN;
                Element e;
                String propertyName = descriptor.getName();
                if (propertyName.equals("class") || !srcName.containsKey(propertyName.toLowerCase()) || (e = els.element(eN = (String)srcName.get(propertyName.toLowerCase()))) == null || !e.hasContent()) continue;
                Method writeMethod = descriptor.getWriteMethod();
                writeMethod.invoke(tt, e.getTextTrim());
            }
            return tt;
        }
        return null;
    }

    private static <T> void getAllDeclaredFields(Map<String, String> srcName, Class<? super T> type) {
        Field[] fs;
        for (Field f : fs = type.getDeclaredFields()) {
            srcName.put(f.getName().toLowerCase(), f.getName());
        }
        if (type.getSuperclass() != null) {
            MGL_XMLUtils.getAllDeclaredFields(srcName, type.getSuperclass());
        }
    }

    private static void toMapFor(Map<String, Object> map, List<Element> echild, String key) throws Exception {
        HashMap<String, Object> c = new HashMap<String, Object>(0);
        for (Element e : echild) {
            if (!StringUtils.isNotBlank((CharSequence)e.getName())) continue;
            List child = e.elements();
            if (child != null && !child.isEmpty()) {
                MGL_XMLUtils.toMapFor(c, child, e.getName());
                continue;
            }
            c.put(e.getName(), e.getText());
        }
        map.put(key, c);
    }

    private static synchronized String parseToURLParams(String xml) {
        return null;
    }

    public void test() {
        try {
            TestModel t = MGL_XMLUtils.parseToBean(MGL_XMLUtils.getPostData(), TestModel.class);
            System.out.println(t.getAppid());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] strs) {
        try {
            Map<String, Object> map = MGL_XMLUtils.parseToMap(MGL_XMLUtils.getPostData());
            logger.info(JSON.toJSONString(map));
            TestModel t = MGL_XMLUtils.parseToBean(MGL_XMLUtils.getPostData(), TestModel.class);
            System.out.println("dddd :" + t.getAppid());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static String getPostData() {
        return "<xml><appid>dsfsdf</appid><attach>[attach]</attach><body>JSAPI\u652f\u4ed8\u6d4b\u8bd5</body><mch_id>[mch_id]</mch_id><nonce_str>1add1a30ac87aa2db72f57a2375d8fec</nonce_str><notify_url>http://wxpay.weixin.qq.com/pub_v2/pay/notify.v2.php</notify_url><openid>oUpF8uMuAJO_M2pxb1Q9zNjWeS6o</openid><out_trade_no>1415659990</out_trade_no><spbill_create_ip>14.23.150.211</spbill_create_ip><total_fee>1</total_fee><trade_type>JSAPI</trade_type><sign><span>dddd</span><div>dddd</div></sign></xml>";
    }

    public static <T> String toXml(T t) {
        return null;
    }
}

