/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MGL_ValidateUtils {
    private static final Logger logger = LoggerFactory.getLogger(MGL_ValidateUtils.class);
    private static final Map<Integer, String> regMap = new HashMap<Integer, String>();
    public static final int USER_NAME = 1;
    public static final int PASSWORD = 2;
    public static final int CHARACTER_SPECIAL = 0;
    public static final int CHARACTER_CHINESE = 3;
    public static final int EMAIL = 4;
    public static final int URL = 5;
    public static final int CHINESE_ID = 6;
    public static final int LETTER_OR_NUMBER = 7;
    public static final int MOBILE_PHONE = 8;
    public static final int POSITIVE_INTEGER = 9;
    public static final int NUMBER = 16;

    public static synchronized boolean validate(Object obj, String myPattern) {
        return MGL_ValidateUtils.validate(obj, null, myPattern, false);
    }

    public static synchronized boolean validate(Object obj, Integer p) {
        return MGL_ValidateUtils.validate(obj, p, null, false);
    }

    public static synchronized boolean validate(Object obj, String myPattern, boolean isNull) {
        return MGL_ValidateUtils.validate(obj, null, myPattern, isNull);
    }

    public static synchronized boolean validate(Object obj, Integer p, boolean isNull) {
        return MGL_ValidateUtils.validate(obj, p, null, isNull);
    }

    public static synchronized boolean validate(Object obj, Integer p, String myPattern, boolean isNull) {
        if (isNull) {
            return true;
        }
        if (obj == null || obj.toString().trim().isEmpty()) {
            return false;
        }
        Pattern pat = Pattern.compile(p != null ? regMap.get(p) : myPattern);
        Matcher mat = pat.matcher(obj.toString());
        return mat.find();
    }

    public static void main(String[] args) {
        System.out.println(MGL_ValidateUtils.validate((Object)"j909090", 7));
        System.out.println("p:" + MGL_ValidateUtils.validate((Object)"18814752232", 8));
        System.out.println("1:" + MGL_ValidateUtils.validate((Object)"13814752222", 9));
        System.out.println("2:" + MGL_ValidateUtils.validate((Object)"-13814752222", 16));
        System.out.println("2:" + MGL_ValidateUtils.validate((Object)"13814752222@qq.com", 4));
    }

    static {
        regMap.put(1, "^[a-zA-Z]\\w{5,17}$");
        regMap.put(2, "^[a-zA-Z]\\w{5,17}$");
        regMap.put(0, "[^%&',;=?$\\x22]+");
        regMap.put(3, "^[\u4e00-\u9fa5]{0,}$");
        regMap.put(4, "^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$");
        regMap.put(5, "^http://([\\w-]+\\.)+[\\w-]+(/[\\w-\\./?%&=]*)?$");
        regMap.put(6, "^\\d{15}|\\d{18}$");
        regMap.put(7, "[a-zA-Z0-9]$");
        regMap.put(8, "^1([3-9][0-9])\\d{8}$");
        regMap.put(9, "^[0-9]*[1-9][0-9]*$");
        regMap.put(16, "^-?\\d+$");
        logger.info("Init Validate Base Pattern Successfully");
    }
}

