/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.time.temporal.TemporalAdjusters;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import tech.mgl.core.utils.MGL_StringUtils;
import tech.mgl.core.utils.QuarterOfYearQuery;

public class MGL_TimeUtils {
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final String FORMAT_DEFAULT = "%02d:%02d:%02d";
    private static final String FORMAT_DEFAULT_MILLISECOND = "%02d:%02d:%02d.%03d";
    public static final String YYYY = "yyyy";
    public static final String YYYY_MM = "yyyy-MM";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String YYYYMMDDHHMM = "yyyyMMddHHmm";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";

    public static synchronized String getCurrentTime(String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
        if (MGL_StringUtils.isNotBlank((CharSequence)pattern)) {
            sdf.applyPattern(pattern);
        } else {
            sdf.applyPattern(YYYY_MM_DD_HH_MM_SS);
        }
        return sdf.format(new Date());
    }

    public static synchronized String getCurrentTime() {
        return MGL_TimeUtils.getCurrentTime("");
    }

    public static synchronized String getShowFormatMS(Long ms) {
        return MGL_TimeUtils.getShowFormatMS(ms, null, false);
    }

    public static synchronized String getShowFormatMS(Long ms, String symbol, boolean showMs) {
        long h = ms / 3600000L;
        long hmo = ms % 3600000L;
        long min = hmo / 60000L;
        long s = (hmo %= 60000L) / 1000L;
        return showMs ? String.format(FORMAT_DEFAULT_MILLISECOND, h, min, s, hmo %= 1000L) : String.format(FORMAT_DEFAULT, h, min, s);
    }

    public static void main(String[] args) {
        try {
            System.out.println(MGL_TimeUtils.getMonth(5));
            SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
            System.out.println(sdf.parse(MGL_TimeUtils.getCurrentTime()));
            System.out.println(MGL_TimeUtils.getShowFormatMS(21000L));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        System.out.println(MGL_TimeUtils.getCurrentTime(YYYY_MM_DD));
        System.out.println(MGL_TimeUtils.getCurrentTime());
        System.out.println(MGL_TimeUtils.getDateAfter(new Date(), 15));
        System.out.println(MGL_TimeUtils.getTime(new Date(), 12, -50));
        System.out.println(MGL_TimeUtils.getMonth(1));
        System.out.println(MGL_TimeUtils.getMonth(0));
        System.out.println(MGL_TimeUtils.getMonth(-5));
        Calendar c = Calendar.getInstance();
        c.setFirstDayOfWeek(2);
        System.out.println(c.get(4));
        System.out.println("------------------------");
        for (int i = 0; i < 12; ++i) {
            int no = i + 1;
            System.out.println("\u4e0a" + no + "\u4e2a\u5929:" + MGL_TimeUtils.getDay(-no));
            System.out.println("\u4e0b" + no + "\u4e2a\u5929:" + MGL_TimeUtils.getDay(no));
        }
        System.out.println("------------------------");
        System.out.println(MGL_TimeUtils.getYear(0));
        System.out.println(MGL_TimeUtils.getMonth(5));
    }

    public static Date getDateAfter(Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(5, now.get(5) + day);
        return now.getTime();
    }

    public static Date getDateBefore(Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(5, now.get(5) - day);
        return now.getTime();
    }

    public static Date getTime(Date d, int calendarVal, int value) {
        Calendar now = Calendar.getInstance();
        if (d != null) {
            now.setTime(d);
        }
        now.add(calendarVal, value);
        return now.getTime();
    }

    public static LocalDate parseDate(String dateStr, String format) {
        return LocalDate.parse(dateStr, DateTimeFormatter.ofPattern(format));
    }

    public static LocalDateTime parseDateTime(String dataTimeStr, String format) {
        return LocalDateTime.parse(dataTimeStr, DateTimeFormatter.ofPattern(format));
    }

    public static String getMonth(int value, String pattern) {
        Calendar now = Calendar.getInstance();
        now.add(2, value);
        return MGL_TimeUtils.format(now.getTime(), pattern);
    }

    public static String getMonth(int value) {
        return MGL_TimeUtils.getMonth(value, YYYY_MM);
    }

    public static int getQuarter(int month) {
        LocalDate date = 0 == month ? LocalDate.now().with(TemporalAdjusters.firstDayOfMonth()) : LocalDate.now().with(Month.of(month)).with(TemporalAdjusters.firstDayOfMonth());
        QuarterOfYearQuery quarterOfYearQuery = new QuarterOfYearQuery();
        return date.query(quarterOfYearQuery);
    }

    public static int getNumber(int type) {
        Calendar now = Calendar.getInstance();
        return now.get(type);
    }

    public static int getMonthNumber() {
        return MGL_TimeUtils.getNumber(2) + 1;
    }

    public static String getYear(int value) {
        LocalDate now = LocalDate.now();
        if (Math.abs(value) == 0) {
            return now.format(DateTimeFormatter.ofPattern(YYYY));
        }
        if (Math.abs(value) > 0) {
            return now.plusYears(value).format(DateTimeFormatter.ofPattern(YYYY));
        }
        return now.minusYears(Math.abs(value)).format(DateTimeFormatter.ofPattern(YYYY));
    }

    public static String getDay(int value, String pattern) {
        return MGL_TimeUtils.format(MGL_TimeUtils.getDate(value), pattern);
    }

    public static String getDay(int value) {
        return MGL_TimeUtils.format(MGL_TimeUtils.getDate(value), YYYY_MM_DD);
    }

    public static Date getDate(int value) {
        Calendar now = Calendar.getInstance();
        now.add(5, value);
        return now.getTime();
    }

    public static LocalDate getLastDayOfMonth() {
        return MGL_TimeUtils.getLastDayOfMonth(null, null);
    }

    public static String getLastDayOfMonth(int month) {
        return MGL_TimeUtils.getLastDayOfMonth(null, null).format(DateTimeFormatter.ofPattern(YYYY_MM_DD));
    }

    public static LocalDate getLastDayOfMonth(Integer year, Integer month) {
        LocalDate now = LocalDate.now();
        int finalYear = year != null ? year.intValue() : now.getYear();
        int finalMonth = month != null ? month.intValue() : now.getMonthValue();
        return LocalDate.of(finalYear, finalMonth, 1).withDayOfMonth(LocalDate.of(finalYear, finalMonth, 1).lengthOfMonth());
    }

    public static LocalDate getFirstDayOfMonth() {
        return MGL_TimeUtils.getFirstDayOfMonth(null, null);
    }

    public static String getFirstDayOfMonth(Integer month) {
        return MGL_TimeUtils.getFirstDayOfMonth(null, month).format(DateTimeFormatter.ofPattern(YYYY_MM_DD));
    }

    public static LocalDate getFirstDayOfMonth(Integer year, Integer month) {
        LocalDate now = LocalDate.now();
        int finalYear = year != null ? year.intValue() : now.getYear();
        int finalMonth = month != null ? month.intValue() : now.getMonthValue();
        return LocalDate.of(finalYear, finalMonth, 1);
    }

    public static int getWeekOfMonth() {
        Calendar now = Calendar.getInstance();
        now.setFirstDayOfWeek(2);
        return now.get(4);
    }

    public static LocalDateTime getLocalTime() {
        return LocalDateTime.now();
    }

    public static int getDayOfWeek() {
        LocalDate today = LocalDate.now();
        DayOfWeek dayOfWeek = today.getDayOfWeek();
        return dayOfWeek.getValue();
    }

    public static int getHourOfDay() {
        LocalDateTime now = LocalDateTime.now();
        return now.getHour();
    }

    public static String getHourOfDayDisplayName() {
        System.out.println(Locale.getDefault().getDisplayName());
        System.out.println(Locale.CHINA.getDisplayName());
        return MGL_TimeUtils.getHourOfDayDisplayName(Locale.getDefault());
    }

    public static String getHourOfDayDisplayName(Locale locale) {
        int hourOfDay = MGL_TimeUtils.getHourOfDay();
        String a = "";
        if (locale.equals(Locale.ENGLISH) || locale.equals(Locale.US)) {
            if (hourOfDay < 6) {
                a = "early morning";
            } else if (hourOfDay < 8) {
                a = "morning";
            } else if (hourOfDay < 12) {
                a = "morning";
            } else if (hourOfDay < 14) {
                a = "noon";
            } else if (hourOfDay < 18) {
                a = "afternoon";
            } else if (hourOfDay < 21) {
                a = "evening";
            } else if (hourOfDay < 24) {
                a = "night";
            } else {
                throw new RuntimeException("invalid time");
            }
        }
        if (locale.equals(Locale.CHINA) || locale.equals(Locale.CHINESE) || locale.equals(Locale.PRC) || locale.equals(Locale.SIMPLIFIED_CHINESE)) {
            if (hourOfDay < 6) {
                a = "\u51cc\u6668";
            } else if (hourOfDay < 8) {
                a = "\u65e9\u4e0a";
            } else if (hourOfDay < 12) {
                a = "\u4e0a\u5348";
            } else if (hourOfDay < 14) {
                a = "\u4e2d\u5348";
            } else if (hourOfDay < 18) {
                a = "\u4e0b\u5348";
            } else if (hourOfDay < 21) {
                a = "\u508d\u665a";
            } else if (hourOfDay < 24) {
                a = "\u665a\u4e0a";
            } else {
                throw new RuntimeException("invalid time");
            }
        }
        return a;
    }

    public static String getDayOfWeekDisplayName() {
        return MGL_TimeUtils.getDayOfWeekDisplayName(Locale.getDefault());
    }

    public static String getDayOfWeekDisplayName(Locale locale) {
        LocalDate today = LocalDate.now();
        DayOfWeek dayOfWeek = today.getDayOfWeek();
        return dayOfWeek.getDisplayName(TextStyle.FULL, locale == null ? Locale.getDefault() : locale);
    }

    public static synchronized String format(Date time, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
        if (StringUtils.isNotBlank((CharSequence)pattern)) {
            sdf.applyPattern(pattern);
        }
        return sdf.format(time);
    }

    public static synchronized String format(Date time) {
        return MGL_TimeUtils.format(time, null);
    }

    public static Date getTime(int calendarVal, int value) {
        return MGL_TimeUtils.getTime(null, calendarVal, value);
    }

    public static long differentDays(String start, String end) {
        return (MGL_TimeUtils.strToDate(end).getTime() - MGL_TimeUtils.strToDate(start).getTime()) / 86400000L;
    }

    public static long differentHours(String start, String end) {
        return (MGL_TimeUtils.strToDate(end).getTime() - MGL_TimeUtils.strToDate(start).getTime()) / 3600000L;
    }

    public static Date strToDate(String strDate) {
        return MGL_TimeUtils.strToDate(strDate, null);
    }

    public static Date strToDate(String strDate, String pattern) {
        SimpleDateFormat formatter = StringUtils.isNotBlank((CharSequence)pattern) ? new SimpleDateFormat(pattern) : new SimpleDateFormat(YYYY_MM_DD);
        ParsePosition pos = new ParsePosition(0);
        return formatter.parse(strDate, pos);
    }

    public static Date getAppointDayOfEndTime(Date date, Integer days) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, days);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getAppointDayCurrentTime(Date date, Integer days) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, days);
        c.set(14, 0);
        return c.getTime();
    }

    public static String getRunTime(long startTime) {
        long tempTime = System.currentTimeMillis() - startTime;
        String runTime = ((String)(tempTime / 86400000L > 0L ? tempTime / 86400000L + "d" : "")).concat((String)(tempTime / 86400000L > 0L || tempTime % 86400000L / 3600000L > 0L ? tempTime % 86400000L / 3600000L + "h" : "")).concat((String)(tempTime / 3600000L > 0L || tempTime % 3600000L / 60000L > 0L ? tempTime % 3600000L / 60000L + "m" : "")).concat((String)(tempTime / 60000L > 0L || tempTime % 60000L / 1000L > 0L ? tempTime % 60000L / 1000L + "s" : "")).concat(tempTime % 1000L + "ms");
        return runTime;
    }
}

