/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class MGL_StringUtils
extends StringUtils {
    public static String getFirstNonEmptyString(String ... strings) {
        if (strings != null) {
            for (String str : strings) {
                if (str == null || str.trim().isEmpty()) continue;
                return str;
            }
        }
        return null;
    }

    public static String trimAll(String str) {
        return str.replaceAll("\\s", "");
    }

    public static String inputStream2String(InputStream inStream) throws IOException {
        try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            String string = outStream.toString(StandardCharsets.UTF_8);
            return string;
        }
    }

    public static InputStream string2inputStream(String str) {
        return new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));
    }

    public static String convertCamelStringToPath(String input) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char currentChar = input.charAt(i);
            if (Character.isUpperCase(currentChar)) {
                if (i > 0) {
                    result.append('/');
                }
                result.append(Character.toLowerCase(currentChar));
                continue;
            }
            result.append(currentChar);
        }
        return result.toString();
    }

    public static List<String> queryDigits(String str) {
        Pattern pattern = Pattern.compile("\\d+");
        Matcher matcher = pattern.matcher(str);
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.find()) {
            list.add(matcher.group());
        }
        return list;
    }

    public static void main(String[] args) {
        String result = MGL_StringUtils.getFirstNonEmptyString("", "  ", null, "World", "Hello");
        System.out.println(result);
    }
}

