/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import tech.mgl.core.stream.MGLStreamCopier;
import tech.mgl.core.stream.MGLStreamProgress;
import tech.mgl.core.utils.MGL_Asserts;
import tech.mgl.core.utils.stream.FastByteArrayOutputStream;

public class MGL_StreamUtils {
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    public static long copy(FileChannel inChannel, FileChannel outChannel) throws RuntimeException {
        MGL_Asserts.notNull(inChannel, "In channel is null!", new Object[0]);
        MGL_Asserts.notNull(outChannel, "Out channel is null!", new Object[0]);
        try {
            return MGL_StreamUtils.copySafely(inChannel, outChannel);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] readBytes(InputStream in, boolean isClose) throws RuntimeException, IOException {
        return MGL_StreamUtils.read(in, isClose).toByteArray();
    }

    public static long copy(InputStream in, OutputStream out) throws RuntimeException {
        return MGL_StreamUtils.copy(in, out, 8192, -1L, null);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize, long count, MGLStreamProgress streamProgress) throws RuntimeException {
        return new MGLStreamCopier(bufferSize, count, streamProgress).copy(in, out);
    }

    public static FastByteArrayOutputStream read(InputStream in, boolean isClose) throws IOException {
        FastByteArrayOutputStream out = in instanceof FileInputStream ? new FastByteArrayOutputStream(in.available()) : new FastByteArrayOutputStream();
        try {
            MGL_StreamUtils.copy(in, out);
        }
        finally {
            if (isClose) {
                MGL_StreamUtils.close(in);
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(FileInputStream in, FileOutputStream out) {
        long l;
        MGL_Asserts.notNull(in, "FileInputStream is null!", new Object[0]);
        MGL_Asserts.notNull(out, "FileOutputStream is null!", new Object[0]);
        FileChannel inChannel = null;
        FileChannel outChannel = null;
        try {
            inChannel = in.getChannel();
            outChannel = out.getChannel();
            l = MGL_StreamUtils.copy(inChannel, outChannel);
        }
        catch (Throwable throwable) {
            MGL_StreamUtils.close(outChannel);
            MGL_StreamUtils.close(inChannel);
            throw throwable;
        }
        MGL_StreamUtils.close(outChannel);
        MGL_StreamUtils.close(inChannel);
        return l;
    }

    private static long copySafely(FileChannel inChannel, FileChannel outChannel) throws IOException {
        long writeBytes;
        long totalBytes = inChannel.size();
        long pos = 0L;
        for (long remaining = totalBytes; remaining > 0L; remaining -= writeBytes) {
            writeBytes = inChannel.transferTo(pos, remaining, outChannel);
            pos += writeBytes;
        }
        return totalBytes;
    }

    public static void close(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected int bufferSize(long count) {
        return (int)Math.min(8192L, count);
    }

    public long copy(ReadableByteChannel source, WritableByteChannel target, long count) {
        long size;
        MGL_Asserts.notNull(source, "InputStream is null !", new Object[0]);
        MGL_Asserts.notNull(target, "OutputStream is null !", new Object[0]);
        try {
            size = this.doCopy(source, target, ByteBuffer.allocate(this.bufferSize(count)), count);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return size;
    }

    private long doCopy(ReadableByteChannel source, WritableByteChannel target, ByteBuffer buffer, long count) throws IOException {
        int read;
        long numToRead = count > 0L ? count : Long.MAX_VALUE;
        long total = 0L;
        while (numToRead > 0L && (read = source.read(buffer)) >= 0) {
            buffer.flip();
            target.write(buffer);
            buffer.clear();
            numToRead -= (long)read;
            total += (long)read;
        }
        return total;
    }
}

