/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.random.RandomGenerator;

public class MGL_RandomUtils {
    private static final RandomGenerator random = RandomGenerator.getDefault();
    private static final char[] NUMBERS = "0123456789".toCharArray();
    private static final char[] LOWERCASE = "abcdefghjkmnopqrstuvwxyz".toCharArray();
    private static final char[] UPPERCASE = "ABCDEFGHJKMNOPQRSTUVWXYZ".toCharArray();

    public static int getRandomNum(int min, int max) {
        return ThreadLocalRandom.current().nextInt(min, max) % (max - min + 1) + min;
    }

    public static int getRandomNumber(int min, int bound) {
        return ThreadLocalRandom.current().nextInt(min, bound);
    }

    public static long getMinNumber(int length) {
        return (long)Math.pow(10.0, length - 1);
    }

    public static long getMaxNumber(int length) {
        return (long)Math.pow(10.0, length) - 1L;
    }

    public static String generateNumber() {
        return MGL_RandomUtils.generateNumber(6);
    }

    public static String generateNumber(int length) {
        return MGL_RandomUtils.generateCode(length, 0, false);
    }

    public static String generateCode(int length, int level, boolean repeat) {
        try {
            if (length <= 0) {
                throw new IllegalArgumentException("Length must be greater than 0");
            }
            char[] pool = MGL_RandomUtils.buildCharacterPool(level);
            if (pool.length == 0) {
                throw new IllegalArgumentException("Invalid level: " + level);
            }
            StringBuilder result = new StringBuilder(length);
            HashSet<Character> usedChars = new HashSet<Character>();
            for (int i = 0; i < length; ++i) {
                int index = ThreadLocalRandom.current().nextInt(pool.length);
                char selectedChar = pool[index];
                if (!repeat) {
                    while (usedChars.contains(Character.valueOf(selectedChar))) {
                        index = ThreadLocalRandom.current().nextInt(pool.length);
                        selectedChar = pool[index];
                    }
                    usedChars.add(Character.valueOf(selectedChar));
                }
                result.append(selectedChar);
            }
            return result.toString();
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    private static char[] buildCharacterPool(int level) {
        return switch (level) {
            case 0 -> NUMBERS;
            case 1 -> LOWERCASE;
            case 2 -> UPPERCASE;
            case 3 -> MGL_RandomUtils.concatenateArrays(NUMBERS, LOWERCASE);
            case 4 -> MGL_RandomUtils.concatenateArrays(NUMBERS, UPPERCASE);
            case 5 -> MGL_RandomUtils.concatenateArrays(NUMBERS, LOWERCASE, UPPERCASE);
            default -> throw new IllegalArgumentException("Invalid level: " + level);
        };
    }

    private static char[] concatenateArrays(char[] ... arrays) {
        int totalLength = Arrays.stream(arrays).mapToInt(arr -> ((char[])arr).length).sum();
        char[] result = new char[totalLength];
        int currentPos = 0;
        for (char[] array : arrays) {
            System.arraycopy(array, 0, result, currentPos, array.length);
            currentPos += array.length;
        }
        return result;
    }

    public static String generateCode(int length) {
        return MGL_RandomUtils.generateCode(length, 5, true);
    }

    public static String generateCode() {
        return MGL_RandomUtils.generateCode(6, 5, true);
    }

    public static String generateCode(int length, int level) {
        return MGL_RandomUtils.generateCode(length, level, true);
    }
}

