/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum MGL_PropertyNamingUtils {
    CamelCase,
    CamelCaseJava,
    PascalCase,
    SnakeCase,
    ClassNameCase,
    KebabCase;


    public String translate(String propertyName) {
        switch (this.ordinal()) {
            case 3: {
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < propertyName.length(); ++i) {
                    char ch = propertyName.charAt(i);
                    if (ch >= 'A' && ch <= 'Z') {
                        char ch_ucase = (char)(ch + 32);
                        if (i > 0) {
                            buf.append('_');
                        }
                        buf.append(ch_ucase);
                        continue;
                    }
                    buf.append(ch);
                }
                return buf.toString();
            }
            case 5: {
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < propertyName.length(); ++i) {
                    char ch = propertyName.charAt(i);
                    if (ch >= 'A' && ch <= 'Z') {
                        char ch_ucase = (char)(ch + 32);
                        if (i > 0) {
                            buf.append('-');
                        }
                        buf.append(ch_ucase);
                        continue;
                    }
                    buf.append(ch);
                }
                return buf.toString();
            }
            case 2: {
                char ch = propertyName.charAt(0);
                if (ch >= 'a' && ch <= 'z') {
                    char[] chars = propertyName.toCharArray();
                    chars[0] = (char)(chars[0] - 32);
                    return new String(chars);
                }
                return propertyName;
            }
            case 0: {
                char ch = propertyName.charAt(0);
                if (ch >= 'A' && ch <= 'Z') {
                    char[] chars = propertyName.toCharArray();
                    chars[0] = (char)(chars[0] + 32);
                    return new String(chars);
                }
                return propertyName;
            }
            case 1: {
                StringBuffer sb = new StringBuffer();
                Pattern p = Pattern.compile("_[a-z|A-Z]");
                Matcher m = p.matcher(propertyName);
                while (m.find()) {
                    m.appendReplacement(sb, m.group().toUpperCase());
                }
                m.appendTail(sb);
                return sb.toString().replaceAll("_", "");
            }
            case 4: {
                return PascalCase.translate(propertyName).replaceAll("_", "");
            }
        }
        return propertyName;
    }

    public static void main(String[] args) {
        System.out.println(CamelCase.translate("sldkfj_sdlkfj"));
        System.out.println(KebabCase.translate("sldkfj_sdlkfj"));
        System.out.println(PascalCase.translate("sldkfj_sdlkfj"));
        System.out.println(SnakeCase.translate("sldkfj_sdlkfj"));
    }
}

