/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils;

import java.util.Collection;
import java.util.Objects;
import tech.mgl.core.utils.MGL_StringUtils;

public class MGL_ObjectUtils {
    public static boolean isCollectionOrArray(Object obj) {
        if (Objects.isNull(obj) || Objects.equals("", obj)) {
            return false;
        }
        return MGL_ObjectUtils.isCollection(obj) || MGL_ObjectUtils.isArray(obj);
    }

    public static boolean isArray(Object obj) {
        if (Objects.isNull(obj) || Objects.equals("", obj)) {
            return false;
        }
        return obj instanceof Object[] || obj.getClass().isArray();
    }

    public static boolean isCollection(Object obj) {
        if (Objects.isNull(obj) || Objects.equals("", obj)) {
            return false;
        }
        return obj instanceof Collection;
    }

    public static boolean isBlank(String str) {
        return MGL_StringUtils.isBlank((CharSequence)str);
    }

    public static boolean isNotBlank(String str) {
        return !MGL_StringUtils.isBlank((CharSequence)str);
    }

    public static <T> boolean isEmpty(T obj) {
        if (obj == null || "".equals(obj)) {
            return true;
        }
        if (obj instanceof String) {
            return MGL_StringUtils.isBlank((CharSequence)obj.toString());
        }
        if (MGL_ObjectUtils.isArray(obj)) {
            return ((Object[])obj).length == 0;
        }
        if (MGL_ObjectUtils.isCollection(obj)) {
            return ((Collection)obj).isEmpty();
        }
        return false;
    }

    public static <T> boolean isNotEmpty(T obj) {
        return !MGL_ObjectUtils.isEmpty(obj);
    }

    public static <T> boolean isNull(T obj) {
        return Objects.isNull(obj) || "".equals(obj) || Objects.equals("", obj);
    }

    public static <T> boolean isNotNull(T obj) {
        return !MGL_ObjectUtils.isNull(obj);
    }
}

