/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.MultiPartEmail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.core.config.MGL_EMailConfig;

public class MGL_MailUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)MGL_MailUtils.class.getName());

    public static synchronized boolean sendSimpleMail(MGL_EMailConfig config, String ... toEmails) {
        if (toEmails == null || toEmails.length <= 0) {
            throw new NullPointerException("\u6536\u4ef6\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (config == null || StringUtils.isBlank((CharSequence)config.getContent()) || StringUtils.isBlank((CharSequence)config.getFromEmail()) || StringUtils.isBlank((CharSequence)config.getSubject())) {
            throw new NullPointerException(">>>> content , fromEmail , subject , smtp ,Authentication ,AuthenticationCode \u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            HtmlEmail email = new HtmlEmail();
            email.setHostName(config.getSmtp());
            email.setAuthentication(config.getAuthentication(), config.getAuthenticationCode());
            email.setCharset(StringUtils.isNotBlank((CharSequence)config.getCharset()) ? config.getCharset() : "UTF-8");
            email.setFrom(config.getFromEmail(), config.getName(), StringUtils.isNotBlank((CharSequence)config.getCharset()) ? config.getCharset() : "UTF-8");
            email.addTo(toEmails);
            email.setSubject(config.getSubject());
            email.setHtmlMsg(config.getContent().toString());
            logger.info(email.send());
            email = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            return false;
        }
        return true;
    }

    public static synchronized boolean sendMultiPartEmail(MGL_EMailConfig config, String ... toEmails) {
        if (toEmails == null || toEmails.length <= 0) {
            throw new NullPointerException("\u6536\u4ef6\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (config == null || StringUtils.isBlank((CharSequence)config.getContent()) || StringUtils.isBlank((CharSequence)config.getFromEmail()) || StringUtils.isBlank((CharSequence)config.getSubject()) || config.getFiles() == null || config.getFiles().isEmpty() || config.getFiles().size() <= 0) {
            throw new NullPointerException(">>>> content , fromEmail , subject , smtp ,Authentication ,AuthenticationCode,Files \u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            MultiPartEmail email = new MultiPartEmail();
            email.setCharset(StringUtils.isNotBlank((CharSequence)config.getCharset()) ? config.getCharset() : "UTF-8");
            email.setHostName(config.getSmtp());
            email.setAuthentication(config.getAuthentication(), config.getAuthenticationCode());
            email.setFrom(config.getFromEmail(), config.getName(), StringUtils.isNotBlank((CharSequence)config.getCharset()) ? config.getCharset() : "UTF-8");
            email.addTo(toEmails);
            email.setSubject(config.getSubject());
            email.setMsg(config.getContent().toString());
            for (File file : config.getFiles()) {
                EmailAttachment attachment = new EmailAttachment();
                attachment.setPath(file.getPath());
                attachment.setName(file.getName());
                attachment.setDescription(file.getName());
                attachment.setDisposition("attachment");
                email.attach(attachment);
            }
            logger.info(email.send());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            return false;
        }
        return true;
    }
}

