/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MGL_JwtUtils {
    private static final Logger logger = LoggerFactory.getLogger(MGL_JwtUtils.class);
    public static final String CLAIMS_KEY_ID = "id";
    public static final String CLAIMS_KEY_NAME = "name";
    public static final String CLAIMS_KEY_NICK_NAME = "nick_name";

    public static String generateToken(String signingKey, Map<String, Object> claims, String subject, long expireTime) throws Exception {
        JwtBuilder builder = Jwts.builder();
        if (null != claims && !claims.isEmpty()) {
            builder.addClaims(claims);
            subject = claims.get(CLAIMS_KEY_ID).toString();
        }
        Date now = new Date();
        builder.setIssuedAt(new Date());
        builder.setSubject(subject).signWith((Key)MGL_JwtUtils.generalKey(signingKey)).setId(UUID.randomUUID().toString());
        if (expireTime < 0L) {
            throw new NullPointerException("\u8fc7\u671f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0");
        }
        long expMillis = now.getTime() + expireTime * 1000L;
        Date exp = new Date(expMillis);
        builder.setExpiration(exp);
        return builder.compact();
    }

    public static String generateToken(String signingKey, String subject, long expireTime) throws Exception {
        return MGL_JwtUtils.generateToken(signingKey, null, subject, expireTime);
    }

    private static SecretKey generalKey(String skey) {
        String stringKey = "MGL.TECH" + skey;
        byte[] encodedKey = Base64.getMimeDecoder().decode(stringKey.getBytes(StandardCharsets.UTF_8));
        SecretKeySpec key = new SecretKeySpec(encodedKey, 0, encodedKey.length, SignatureAlgorithm.HS512.getJcaName());
        return key;
    }

    public static Claims getClm(String token, String signingKey) throws ExpiredJwtException {
        if (token == null) {
            return null;
        }
        try {
            Jws jws = Jwts.parserBuilder().setSigningKey((Key)MGL_JwtUtils.generalKey(signingKey)).build().parseClaimsJws(token);
            return (Claims)jws.getBody();
        }
        catch (Exception e) {
            if (ExpiredJwtException.class.getName().equals(e.getClass().getName())) {
                logger.info(e.getClass().getName());
                throw e;
            }
            logger.error("\u5176\u4ed6\u4e0d\u5408\u6cd5\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static boolean verifyToken(String token, String signingKey) {
        try {
            if (MGL_JwtUtils.getClm(token, signingKey) == null) {
                return false;
            }
        }
        catch (ExpiredJwtException e) {
            return false;
        }
        return true;
    }

    public static JwtParser getParser(String signingKey) {
        return Jwts.parserBuilder().setSigningKey(signingKey).build();
    }
}

