/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.PropertyNamingStrategy;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.filter.PropertyFilter;
import jakarta.persistence.Column;
import jakarta.persistence.Table;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.core.config.MGL_JSONConfig;
import tech.mgl.core.utils.MGL_ClassUtils;

public class MGL_JsonUtils {
    private static final String DEFAULT_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String GEN_KEY_PREFIX = "content_";
    private static final Logger logger = LoggerFactory.getLogger(MGL_JsonUtils.class);

    private static synchronized JSONObject base(MGL_JSONConfig jconfig, Object ... objs) {
        JSONObject j = new JSONObject();
        if (objs != null) {
            String timeFormat = DEFAULT_TIME_FORMAT;
            String keyPrefix = GEN_KEY_PREFIX;
            ArrayList<String> include = new ArrayList<String>(0);
            ArrayList<String> exclude = new ArrayList<String>(0);
            boolean gen_key = true;
            if (jconfig != null) {
                String string = timeFormat = StringUtils.isNotBlank((CharSequence)jconfig.getTimeFormat()) ? jconfig.getTimeFormat() : DEFAULT_TIME_FORMAT;
                if (jconfig.getIncludes() != null && !jconfig.getIncludes().isEmpty() && !jconfig.getIncludes().isEmpty()) {
                    include.addAll(jconfig.getIncludes());
                }
                if (jconfig.getExcludes() != null && !jconfig.getExcludes().isEmpty() && !jconfig.getExcludes().isEmpty()) {
                    exclude.addAll(jconfig.getExcludes());
                }
                boolean bl = gen_key = jconfig.getGenKey() != null ? jconfig.getGenKey() : true;
                if (StringUtils.isNotBlank((CharSequence)jconfig.getKeyPrefix())) {
                    keyPrefix = jconfig.getKeyPrefix();
                }
            }
            int i = 1;
            for (Object obj : objs) {
                if (null == obj) continue;
                PropertyFilter filter = null;
                Object content = null;
                if (!include.isEmpty()) {
                    filter = (source, name, value) -> include.contains(name);
                } else if (!exclude.isEmpty()) {
                    filter = (source, name, value) -> !exclude.contains(name);
                }
                if (obj instanceof String) {
                    content = obj;
                } else if (null != filter) {
                    Object tempO = JSON.toJSON((Object)obj);
                    String temp = JSON.toJSONString((Object)tempO, (Filter)filter, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.BrowserCompatible});
                    if (StringUtils.isBlank((CharSequence)temp) || "\"\"".equals(temp)) continue;
                    content = tempO instanceof JSONObject ? JSON.parseObject((String)temp) : JSON.parseArray((String)temp);
                } else {
                    content = JSON.toJSON((Object)obj);
                }
                if (gen_key || objs.length > 1) {
                    if (null == content || StringUtils.isBlank((CharSequence)content.toString())) continue;
                    if (content instanceof JSONArray) {
                        j.put((Object)(keyPrefix + i), content);
                    } else if (content instanceof JSONObject) {
                        j.put((Object)(keyPrefix + i), content);
                    } else {
                        j.put((Object)(keyPrefix + i), (Object)content.toString());
                    }
                    ++i;
                    continue;
                }
                if (content instanceof String) {
                    j.put((Object)(GEN_KEY_PREFIX + i), content);
                    continue;
                }
                j.putAll((Map)JSON.parseObject((String)content.toString()));
            }
        }
        return j;
    }

    public static synchronized JSONObject from(MGL_JSONConfig jconfig, Object ... objs) {
        return MGL_JsonUtils.base(jconfig, objs);
    }

    public static synchronized JSONObject from(Object ... objs) {
        return MGL_JsonUtils.base(null, objs);
    }

    public static synchronized String obj2JSONString(MGL_JSONConfig config, Object ... objs) {
        JSONObject obj;
        Object temp_prefix = "content_1";
        if (config == null) {
            config = new MGL_JSONConfig();
        }
        if (config.getGenKey() == null) {
            config.setGenKey(false);
        }
        if (StringUtils.isNotBlank((CharSequence)config.getKeyPrefix())) {
            temp_prefix = config.getKeyPrefix() + "1";
        }
        JSONObject json = MGL_JsonUtils.base(config, objs);
        Object object = obj = objs.length == 1 ? json.getOrDefault((String)temp_prefix, (Object)json) : json;
        if (config.getBrowserCompatible() != null && config.getBrowserCompatible().booleanValue()) {
            return JSON.toJSONString((Object)obj, (String)config.getTimeFormat(), (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.BrowserCompatible});
        }
        return JSON.toJSONString((Object)obj, (String)config.getTimeFormat(), (JSONWriter.Feature[])new JSONWriter.Feature[0]);
    }

    public static synchronized String obj2JSONString(Object ... objs) {
        return MGL_JsonUtils.obj2JSONString(null, objs);
    }

    public static synchronized String result(boolean status, Integer p_status, String info, Object content, MGL_JSONConfig config) {
        JSONObject json = new JSONObject();
        if (p_status != null) {
            json.put((Object)"p_status", (Object)p_status);
        }
        json.put((Object)"r_status", (Object)status);
        json.put((Object)"r_info", (Object)info);
        if (content instanceof JSONObject) {
            json.putAll((Map)JSON.parseObject((String)JSON.toJSONString((Object)JSON.toJSON((Object)content), (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.BrowserCompatible})));
        } else if (config != null) {
            System.out.println(MGL_JsonUtils.base(config, content));
            json.put((Object)"r_content", MGL_JsonUtils.base(config, content).get(config.getKeyPrefix() + "1"));
        } else {
            json.put((Object)"r_content", JSON.toJSON((Object)content));
        }
        return JSON.toJSONString((Object)json, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.BrowserCompatible});
    }

    public static synchronized String result(boolean status, String info) {
        return MGL_JsonUtils.result(status, null, info, null, null);
    }

    public static synchronized String result(boolean status, String info, Object obj) {
        return MGL_JsonUtils.result(status, null, info, obj, null);
    }

    public static synchronized String result(boolean status, String info, Object obj, MGL_JSONConfig config) {
        return MGL_JsonUtils.result(status, null, info, obj, config);
    }

    public static synchronized String result(boolean status, Integer p_status) {
        return MGL_JsonUtils.result(status, p_status, null, null, null);
    }

    public static synchronized String result(boolean status) {
        return MGL_JsonUtils.result(status, null, null, null, null);
    }

    public static synchronized String result(boolean status, Integer p_status, String info) {
        return MGL_JsonUtils.result(status, p_status, info, null, null);
    }

    public static synchronized <T> T toBean(JSONObject from, Class<T> toCls) throws Exception {
        BeanInfo beanInfo = Introspector.getBeanInfo(toCls);
        T t = toCls.newInstance();
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            Object value;
            PropertyDescriptor descriptor = propertyDescriptors[i];
            String propertyName = descriptor.getName();
            if (!from.containsKey(propertyName) || (value = from.get(propertyName)) == null) continue;
            Object[] args = new Object[]{value};
            logger.debug(descriptor.getName() + "( " + descriptor.getPropertyType().getTypeName() + " ) : " + String.valueOf(value) + "(" + value.getClass().getTypeName() + ")");
            descriptor.getWriteMethod().invoke(t, args);
        }
        return t;
    }

    public static <T> T toCaseObject(String json, Class<T> clazz, PropertyNamingStrategy cases) {
        return (T)JSON.parseObject((String)json, clazz);
    }

    @Deprecated
    public static Object toJson(Object obj, PropertyNamingStrategy cases, MGL_JSONConfig config) throws Exception {
        if (null != cases) {
            if (null != config) {
                config.setPropertyNamingStrategy(cases);
            } else {
                MGL_JSONConfig conf = new MGL_JSONConfig();
                conf.setPropertyNamingStrategy(cases);
                return MGL_JsonUtils.toJson(obj, conf);
            }
        }
        return MGL_JsonUtils.toJson(obj, config);
    }

    public static Object toJson(Object obj, MGL_JSONConfig config) throws Exception {
        PropertyFilter filter = null;
        Object object = obj;
        if (null != config) {
            ArrayList<Map<String, Object>> listTemp = new ArrayList<Map<String, Object>>(0);
            if (config.isForColAnnotation()) {
                logger.warn("\u5f53config.isForColAnnotation() true\u65f6 PropertyNamingStrategy\u914d\u7f6e\u5c31\u65e0\u6548\u4e86");
                if (obj instanceof List) {
                    List list = obj;
                    for (Object c : list) {
                        Table table = c.getClass().getAnnotation(Table.class);
                        if (null == table) continue;
                        listTemp.add(MGL_JsonUtils.toMapWithAnnotation(c));
                    }
                    object = listTemp;
                } else {
                    Table table = obj.getClass().getAnnotation(Table.class);
                    if (null != table) {
                        object = MGL_JsonUtils.toMapWithAnnotation(obj);
                    }
                }
            }
            if (config.getIncludes() != null && !config.getIncludes().isEmpty()) {
                filter = (source, name, value) -> config.getIncludes().contains(name);
            } else if (config.getExcludes() != null && !config.getExcludes().isEmpty()) {
                filter = (source, name, value) -> !config.getExcludes().contains(name);
            }
        }
        if (null == filter) {
            return JSON.toJSON((Object)object);
        }
        String str = JSON.toJSONString((Object)JSON.toJSON((Object)object), filter, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.BrowserCompatible});
        if (StringUtils.isNotBlank((CharSequence)str)) {
            return JSON.parse((String)str);
        }
        return null;
    }

    public static Object toJson(Object obj, PropertyNamingStrategy cases) throws Exception {
        return MGL_JsonUtils.toJson(obj, cases, null);
    }

    public static synchronized Map<String, Object> toMapWithAnnotation(Object t) throws Exception {
        BeanInfo beanInfo = Introspector.getBeanInfo(t.getClass());
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        HashMap<String, Object> map = new HashMap<String, Object>(0);
        for (PropertyDescriptor descriptor : propertyDescriptors) {
            Object value = descriptor.getReadMethod().invoke(t, new Object[0]);
            Column column = descriptor.getReadMethod().getAnnotation(Column.class);
            if (null == column) continue;
            map.put(column.name(), value);
        }
        return map;
    }

    static {
        if (!MGL_ClassUtils.isPresent("com.alibaba.fastjson2.JSON")) {
            logger.warn("\u672a\u5bfc\u5165\u6307\u5b9a\u7684\u5305\uff0c\u53ef\u5bfc\u5165fastjson2\u5305\uff0c\u5f00\u542fMGL_JsonUtils\u529f\u80fd\uff01");
        }
    }
}

