/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils;

import org.apache.commons.lang3.StringUtils;

public class MGL_IPUtils {
    public static boolean ipV4Validate(String ip) {
        if (StringUtils.isEmpty((CharSequence)ip)) {
            return false;
        }
        String regex = "^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$";
        return ip.matches(regex);
    }

    public static boolean ipIsValid(String ipSection, String ip) {
        if (ipSection == null) {
            throw new NullPointerException("IP\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (ip == null) {
            throw new NullPointerException("IP\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ipSection = ipSection.trim();
        ip = ip.trim();
        String REGX_IP = "((25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)";
        String REGX_IPB = "((25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\-((25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)";
        if (!ipSection.matches("((25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\-((25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)") || !ip.matches("((25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)")) {
            return false;
        }
        int idx = ipSection.indexOf(45);
        String[] sips = ipSection.substring(0, idx).split("\\.");
        String[] sipe = ipSection.substring(idx + 1).split("\\.");
        String[] sipt = ip.split("\\.");
        long ips = 0L;
        long ipe = 0L;
        long ipt = 0L;
        for (int i = 0; i < 4; ++i) {
            ips = ips << 8 | (long)Integer.parseInt(sips[i]);
            ipe = ipe << 8 | (long)Integer.parseInt(sipe[i]);
            ipt = ipt << 8 | (long)Integer.parseInt(sipt[i]);
        }
        if (ips > ipe) {
            long t = ips;
            ips = ipe;
            ipe = t;
        }
        return ips <= ipt && ipt <= ipe;
    }

    public static boolean isInRange(String ip, String cidr) {
        String cidrIp;
        String[] cidrIps;
        int cidrIpAddr;
        int type;
        int mask;
        String[] ips = ip.split("\\.");
        int ipAddr = Integer.parseInt(ips[0]) << 24 | Integer.parseInt(ips[1]) << 16 | Integer.parseInt(ips[2]) << 8 | Integer.parseInt(ips[3]);
        return (ipAddr & (mask = -1 << 32 - (type = Integer.parseInt(cidr.replaceAll(".*/", ""))))) == ((cidrIpAddr = Integer.parseInt((cidrIps = (cidrIp = cidr.replaceAll("/.*", "")).split("\\."))[0]) << 24 | Integer.parseInt(cidrIps[1]) << 16 | Integer.parseInt(cidrIps[2]) << 8 | Integer.parseInt(cidrIps[3])) & mask);
    }

    public long ipToLong(String strIP) {
        long[] ip = new long[4];
        int position1 = strIP.indexOf(".");
        int position2 = strIP.indexOf(".", position1 + 1);
        int position3 = strIP.indexOf(".", position2 + 1);
        ip[0] = Long.parseLong(strIP.substring(0, position1));
        ip[1] = Long.parseLong(strIP.substring(position1 + 1, position2));
        ip[2] = Long.parseLong(strIP.substring(position2 + 1, position3));
        ip[3] = Long.parseLong(strIP.substring(position3 + 1));
        return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
    }

    public String longToIP(long longIP) {
        StringBuffer sb = new StringBuffer("");
        sb.append(String.valueOf(longIP >>> 24));
        sb.append(".");
        sb.append(String.valueOf((longIP & 0xFFFFFFL) >>> 16));
        sb.append(".");
        sb.append(String.valueOf((longIP & 0xFFFFL) >>> 8));
        sb.append(".");
        sb.append(String.valueOf(longIP & 0xFFL));
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println(MGL_IPUtils.isInRange("26.124.2.2", "26.124.0.255/23"));
        System.out.println();
        if (MGL_IPUtils.ipIsValid("192.168.0.0-192.168.1.11", "192.169.1.54")) {
            System.out.println("ip\u5c5e\u4e8e\u8be5\u7f51\u6bb5");
        } else {
            System.out.println("ip\u4e0d\u5c5e\u4e8e\u8be5\u7f51\u6bb5");
        }
    }
}

