/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils;

import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import tech.mgl.core.utils.security.MGL_Encryption;

public class MGL_HardwareUtils {
    private static final int SPLITLENGTH = 4;
    private static final String SALT = "mgl.tech";

    public static void main(String[] args) throws Exception {
        String code = MGL_HardwareUtils.getMachineCode();
        System.out.println("code:" + code);
        String authCode = MGL_HardwareUtils.auth(code);
        System.out.println("\u673a\u5668\u7801\uff1a" + code);
        System.out.println("\u6ce8\u518c\u7801\uff1a" + authCode);
    }

    private static String getMachineCode() throws Exception {
        HashSet<String> result = new HashSet<String>();
        String mac = MGL_HardwareUtils.getMac();
        System.out.println("mac:" + MGL_HardwareUtils.getMac());
        result.add(mac);
        Properties props = System.getProperties();
        String javaVersion = props.getProperty("java.version");
        result.add(javaVersion);
        String javaVMVersion = props.getProperty("java.vm.version");
        result.add(javaVMVersion);
        String osVersion = props.getProperty("os.version");
        result.add(osVersion);
        String code = MGL_Encryption.password_pvpgn_hash(((Object)result).toString() + SALT);
        return MGL_HardwareUtils.getSplitString(code, "-", 4);
    }

    public static String auth(String machineCode) throws Exception {
        String newCode = "(admin@mgl.tech)[" + machineCode.toUpperCase() + "](\u8499\u53e4\u79d1\u6280)";
        String code = MGL_Encryption.password_pvpgn_hash(newCode + SALT).toUpperCase() + machineCode.length();
        return MGL_HardwareUtils.getSplitString(code);
    }

    private static String getSplitString(String str) {
        return MGL_HardwareUtils.getSplitString(str, "-", 4);
    }

    private static String getSplitString(String str, String split, int length) {
        int len = str.length();
        StringBuilder temp = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            if (i % length == 0 && i > 0) {
                temp.append(split);
            }
            temp.append(str.charAt(i));
        }
        String[] attrs = temp.toString().split(split);
        StringBuilder finalMachineCode = new StringBuilder();
        for (String attr : attrs) {
            if (attr.length() != length) continue;
            finalMachineCode.append(attr).append(split);
        }
        String result = finalMachineCode.toString().substring(0, finalMachineCode.toString().length() - 1);
        return result;
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    private static String getMac() {
        try {
            Enumeration<NetworkInterface> el = NetworkInterface.getNetworkInterfaces();
            while (el.hasMoreElements()) {
                byte[] mac = el.nextElement().getHardwareAddress();
                if (mac == null) continue;
                String hexstr = MGL_HardwareUtils.bytesToHexString(mac);
                return MGL_HardwareUtils.getSplitString(hexstr, "-", 2).toUpperCase();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }
}

