/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import tech.mgl.core.utils.MGL_RandomUtils;
import tech.mgl.core.utils.img.MGL_ImageUtils;

public class MGL_FontUtils {
    private static final String[] fonts = new String[]{"Monotype Corsiva", "\u5b8b\u4f53", "\u65b9\u6b63\u8212\u4f53", "\u96b6\u4e66", "\u65b9\u6b63\u8212\u4f53", "\u534e\u6587\u884c\u6977"};

    public static void fontToImage(String str, Font font, File outFile) throws Exception {
        MGL_FontUtils.fontToImage(str, font, null, outFile, 1.0, 1.0);
    }

    public static void fontToImage(String str, Color color, Font font, File outFile) throws Exception {
        MGL_FontUtils.fontToImage(str, font, color, outFile, 1.0, 1.0);
    }

    public static void fontToImage(String str, Font font, Color color, File outFile, double scaleX, double scaleY) throws Exception {
        Rectangle2D r = font.getStringBounds(str, new FontRenderContext(AffineTransform.getScaleInstance(1.0, 1.0), false, false));
        int width = (int)Math.round(r.getWidth() * scaleX);
        int height = (int)Math.floor(r.getHeight() * scaleY);
        BufferedImage image = MGL_ImageUtils.getTransparentImg(width, height);
        Graphics2D g = image.createGraphics();
        AffineTransform identify = AffineTransform.getScaleInstance(scaleX, scaleY);
        g.setTransform(identify);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (color == null) {
            g.setColor(Color.black);
        } else {
            g.setColor(color);
        }
        g.setFont(font);
        g.drawString(str, 0, font.getSize());
        g.dispose();
        ImageIO.write((RenderedImage)image, "png", outFile);
        image.flush();
    }

    public static Font getRandomFont() {
        return MGL_FontUtils.getRandomFont(0);
    }

    public static Font getRandomFont(int fontSize) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] availableFontFamilyNames = ge.getAvailableFontFamilyNames();
        return new Font(availableFontFamilyNames[MGL_RandomUtils.getRandomNum(0, availableFontFamilyNames.length)], 1, fontSize > 0 ? fontSize : 28);
    }

    public static void main(String[] args) {
        try {
            MGL_FontUtils.fontToImage("\u624b\u52a8\u9600\u624b\u52a8\u9600\u624b\u52a8\u9600", new Font("\u5fae\u8f6f\u96c5\u9ed1", -1, 40), null, new File("d:/a111111111121.png"), 1.4638888888888888, 1.4638888888888888);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

