/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils;

import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.core.utils.MGL_Asserts;

public class MGL_FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(MGL_FileUtils.class);

    public static synchronized File getFileCreate(String path) {
        try {
            MGL_Asserts.notBlank(path, "\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
            File file = new File(path);
            if (!file.exists()) {
                boolean mkdirs;
                if (!file.getParentFile().exists() && !(mkdirs = file.getParentFile().mkdirs())) {
                    throw new Exception("create dirs error");
                }
                boolean newFile = file.createNewFile();
                if (!newFile) {
                    throw new Exception("create file error");
                }
            }
            return file;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static synchronized File getFileCPDir(String path) {
        try {
            boolean tf;
            MGL_Asserts.notBlank(path, "\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
            File file = new File(path);
            if (!file.getParentFile().exists() && !(tf = file.getParentFile().mkdirs())) {
                throw new RuntimeException("\u76ee\u5f55\u83b7\u53d6\u5931\u8d25 file.getParentFile().mkdirs()".concat("false"));
            }
            return file;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public static synchronized File getDirectoryCDir(String path) {
        try {
            boolean tf;
            MGL_Asserts.notBlank(path, "\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
            File file = new File(path);
            if (!file.exists() && !(tf = file.mkdirs())) {
                throw new RuntimeException("\u76ee\u5f55\u83b7\u53d6\u5931\u8d25 file.mkdirs()".concat("false"));
            }
            return file;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    public static synchronized List<Path> getAll(String path) {
        MGL_Asserts.notBlank(path, "\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        List result = null;
        try (Stream<Path> walk = Files.walk(Path.of(path, new String[0]), new FileVisitOption[0]);){
            result = walk.collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return result;
    }

    public static synchronized boolean delete(String path) {
        MGL_Asserts.notBlank(path, "\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        File file = new File(path);
        return MGL_FileUtils.delete(file);
    }

    public static synchronized boolean delete(File file) {
        MGL_Asserts.notEmpty(file, "\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        return file.delete();
    }

    public static synchronized void deleteAll(String dir) {
        File[] files;
        File file = new File(dir);
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File value : files) {
                MGL_FileUtils.deleteAll(value.getAbsolutePath());
            }
        }
        MGL_FileUtils.delete(file);
    }
}

