/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.compress.utils.FileNameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.core.utils.MGL_PropUtils;
import tech.mgl.core.utils.MGL_StringUtils;

public class MGL_FileIOUtils {
    public static final int GEN_IMAGE_NAME = 1;
    public static final int GEN_VIDEO_NAME = 2;
    public static final int GEN_OTHER_NAME = 3;
    private static final String GEN_IMAGE_PREFIX = "IMG_";
    private static final String GEN_VIDEO_PREFIX = "VIO_";
    private static final String GEN_MUSIC_PREFIX = "MUC_";
    private static final String GEN_OTHER_PREFIX = "OTH_";
    private static final String GEN_DOCUMENT_PREFIX = "DOC_";
    private static final Map<String, String> genTypes = new HashMap<String, String>(0);
    private static final Logger logger = LoggerFactory.getLogger(MGL_FileIOUtils.class);
    private static final SimpleDateFormat df;
    private static final SimpleDateFormat sdfFilePath;

    public static synchronized String generatorFileName(String fileName) {
        return MGL_FileIOUtils.generatorFileName(fileName, 0);
    }

    public static synchronized String generatorFileName(String fileName, int key) {
        String newFileName = null;
        String extension = FileNameUtils.getExtension((Path)Paths.get(fileName, new String[0]));
        switch (key) {
            case 0: {
                String tr = genTypes.get(extension.toLowerCase());
                if (StringUtils.isBlank((CharSequence)tr)) {
                    tr = GEN_OTHER_PREFIX;
                }
                newFileName = tr + df.format(new Date()) + System.currentTimeMillis() + RandomStringUtils.randomAlphanumeric((int)4) + "." + extension.toLowerCase();
                break;
            }
            case 1: {
                newFileName = GEN_IMAGE_PREFIX + df.format(new Date()) + System.currentTimeMillis() + RandomStringUtils.randomAlphanumeric((int)4) + "." + extension.toLowerCase();
                break;
            }
            case 2: {
                newFileName = GEN_VIDEO_PREFIX + df.format(new Date()) + System.currentTimeMillis() + RandomStringUtils.randomAlphanumeric((int)4) + "." + extension.toLowerCase();
                break;
            }
            case 3: {
                newFileName = GEN_OTHER_PREFIX + df.format(new Date()) + System.currentTimeMillis() + RandomStringUtils.randomAlphanumeric((int)4) + "." + extension.toLowerCase();
                break;
            }
        }
        return newFileName;
    }

    public static synchronized boolean checkImgType(String type) {
        return MGL_FileIOUtils.checkType(type, 1, null);
    }

    public static synchronized boolean checkVideoType(String type) {
        return MGL_FileIOUtils.checkType(type, 2, null);
    }

    public static synchronized boolean checkType(String type) {
        return MGL_FileIOUtils.checkType(type, 3, null);
    }

    public static synchronized boolean check(String type, String extKey) {
        return MGL_FileIOUtils.checkType(type, 5, extKey);
    }

    private static synchronized boolean checkType(String type, Integer key, String extKey) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return false;
        }
        if (type.contains(".")) {
            type = FileNameUtils.getExtension((Path)Paths.get(type, new String[0]));
        }
        type = type.toLowerCase();
        logger.info("\u56fe\u7247\u683c\u5f0f\uff1a" + type);
        boolean re = false;
        switch (key) {
            case 1: {
                String str = MGL_PropUtils.getVal("uploadImgTypes", "global-cnf");
                if (StringUtils.isNotBlank((CharSequence)str)) {
                    re = ArrayUtils.contains((Object[])MGL_FileIOUtils.getTrimArray(str.trim().split(",")), (Object)type);
                }
                str = null;
                break;
            }
            case 2: {
                String str1 = MGL_PropUtils.getVal("uploadVideoTypes", "global-cnf");
                if (StringUtils.isNotBlank((CharSequence)str1)) {
                    re = ArrayUtils.contains((Object[])MGL_FileIOUtils.getTrimArray(str1.trim().split(",")), (Object)type);
                }
                str1 = null;
                break;
            }
            case 3: {
                Object all = "";
                String str2 = MGL_PropUtils.getVal("uploadOtherTypes", "global-cnf");
                String str4 = MGL_PropUtils.getVal("uploadImgTypes", "global-cnf");
                String str3 = MGL_PropUtils.getVal("uploadVideoTypes", "global-cnf");
                if (StringUtils.isNotBlank((CharSequence)str2)) {
                    all = (String)all + str2;
                    str2 = null;
                }
                if (StringUtils.isNotBlank((CharSequence)str3)) {
                    all = (String)all + "," + str3;
                    str3 = null;
                }
                if (StringUtils.isNotBlank((CharSequence)str4)) {
                    all = (String)all + "," + str4;
                    str4 = null;
                }
                if (StringUtils.isNotBlank((CharSequence)all)) {
                    re = ArrayUtils.contains((Object[])MGL_FileIOUtils.getTrimArray(((String)all).trim().split(",")), (Object)type);
                }
                all = null;
                break;
            }
            case 5: {
                String extList;
                if (extKey.endsWith(".properties")) {
                    extKey = extKey.replace(".properties", "");
                }
                if (StringUtils.isNotBlank((CharSequence)(extList = MGL_PropUtils.getVal(extKey, "global-cnf")))) {
                    re = ArrayUtils.contains((Object[])MGL_FileIOUtils.getTrimArray(extList.trim().split(",")), (Object)type);
                }
                extList = null;
                break;
            }
        }
        return re;
    }

    private static synchronized String[] getTrimArray(String[] strs) {
        String[] _strs = strs;
        for (int i = 0; i < strs.length; ++i) {
            _strs[i] = strs[i].trim();
        }
        return _strs;
    }

    public static synchronized String getEndWithSlashPath(String path) {
        String s = path.trim();
        return s.endsWith("\\") || s.endsWith("/") || s.endsWith(File.separator) ? path : path + File.separator;
    }

    public static synchronized String getStartWithSlashPath(String path) {
        String s = path.trim();
        return s.startsWith("\\") || s.startsWith("/") || s.startsWith(File.separator) ? path : File.separator + path;
    }

    public static synchronized String getPathWithSlashPath(String path) {
        return MGL_FileIOUtils.getEndWithSlashPath(MGL_FileIOUtils.getStartWithSlashPath(path));
    }

    public static synchronized String getRelativePath(String pattern) {
        Object rPath = File.separator + "_mgl_up";
        if (StringUtils.isNotBlank((CharSequence)pattern)) {
            sdfFilePath.applyPattern(pattern);
            rPath = "";
        }
        return (String)rPath + MGL_FileIOUtils.getPathWithSlashPath(sdfFilePath.format(new Date()));
    }

    public static synchronized String getUploadPath(String fileName) {
        return MGL_FileIOUtils.getRelativePath() + MGL_FileIOUtils.generatorFileName(fileName);
    }

    public static synchronized String getRelativePath() {
        return MGL_FileIOUtils.getRelativePath(null);
    }

    public static File copyFileFromJar(String src) {
        return MGL_FileIOUtils.copyFileFromJar(MGL_FileIOUtils.class, src);
    }

    public static File copyFileFromJar(Class<?> cls, String src) {
        return MGL_FileIOUtils.copyFileFromJar(cls, src, null);
    }

    public static File copyFileFromJar(Class<?> cls, String src, String dest) {
        String tempDest = MGL_StringUtils.isBlank((CharSequence)dest) ? src : dest;
        File file = new File(tempDest);
        if (!file.exists()) {
            file = new File((String)(tempDest.startsWith("/") ? tempDest.replaceFirst("/", "") : "/" + tempDest));
        }
        if (!file.exists()) {
            logger.info("final path: {}", (Object)MGL_FileIOUtils.getStartWithSlashPath(src));
            InputStream ist = cls.getResourceAsStream(MGL_FileIOUtils.getStartWithSlashPath(src));
            if (null != ist) {
                boolean mkdirs = file.getParentFile().mkdirs();
                try {
                    Files.copy(ist, file.toPath(), new CopyOption[0]);
                }
                catch (IOException e) {
                    logger.warn(e.getMessage());
                }
                logger.info(file.getAbsolutePath());
            }
        }
        return file;
    }

    public static void main(String[] args) {
        System.out.println(MGL_FileIOUtils.check("ai", "uploadOtherTypes.properties"));
    }

    static {
        genTypes.put("jpg", GEN_IMAGE_PREFIX);
        genTypes.put("jpeg", GEN_IMAGE_PREFIX);
        genTypes.put("gif", GEN_IMAGE_PREFIX);
        genTypes.put("bmp", GEN_IMAGE_PREFIX);
        genTypes.put("ico", GEN_IMAGE_PREFIX);
        genTypes.put("png", GEN_IMAGE_PREFIX);
        genTypes.put("tiff", GEN_IMAGE_PREFIX);
        genTypes.put("pcx", GEN_IMAGE_PREFIX);
        genTypes.put("tga", GEN_IMAGE_PREFIX);
        genTypes.put("exif", GEN_IMAGE_PREFIX);
        genTypes.put("fpx", GEN_IMAGE_PREFIX);
        genTypes.put("svg", GEN_IMAGE_PREFIX);
        genTypes.put("psd", GEN_IMAGE_PREFIX);
        genTypes.put("cdr", GEN_IMAGE_PREFIX);
        genTypes.put("pcd", GEN_IMAGE_PREFIX);
        genTypes.put("dxf", GEN_IMAGE_PREFIX);
        genTypes.put("ufo", GEN_IMAGE_PREFIX);
        genTypes.put("eps", GEN_IMAGE_PREFIX);
        genTypes.put("ai", GEN_IMAGE_PREFIX);
        genTypes.put("raw", GEN_IMAGE_PREFIX);
        genTypes.put("avif", GEN_IMAGE_PREFIX);
        genTypes.put("webp", GEN_IMAGE_PREFIX);
        genTypes.put("heic", GEN_IMAGE_PREFIX);
        genTypes.put("nef", GEN_IMAGE_PREFIX);
        genTypes.put("avi", GEN_VIDEO_PREFIX);
        genTypes.put("mp4", GEN_VIDEO_PREFIX);
        genTypes.put("3gp", GEN_VIDEO_PREFIX);
        genTypes.put("mkv", GEN_VIDEO_PREFIX);
        genTypes.put("f4v", GEN_VIDEO_PREFIX);
        genTypes.put("flv", GEN_VIDEO_PREFIX);
        genTypes.put("asf", GEN_VIDEO_PREFIX);
        genTypes.put("mov", GEN_VIDEO_PREFIX);
        genTypes.put("mpeg", GEN_VIDEO_PREFIX);
        genTypes.put("navi", GEN_VIDEO_PREFIX);
        genTypes.put("rmvb", GEN_VIDEO_PREFIX);
        genTypes.put("wmv", GEN_VIDEO_PREFIX);
        genTypes.put("swf", GEN_VIDEO_PREFIX);
        genTypes.put("rm", GEN_VIDEO_PREFIX);
        genTypes.put("mp3", GEN_MUSIC_PREFIX);
        genTypes.put("ape", GEN_MUSIC_PREFIX);
        genTypes.put("flac", GEN_MUSIC_PREFIX);
        genTypes.put("midi", GEN_MUSIC_PREFIX);
        genTypes.put("wma", GEN_MUSIC_PREFIX);
        genTypes.put("vqf", GEN_MUSIC_PREFIX);
        genTypes.put("wav", GEN_MUSIC_PREFIX);
        genTypes.put("cd", GEN_MUSIC_PREFIX);
        genTypes.put("ogg", GEN_MUSIC_PREFIX);
        genTypes.put("ra", GEN_MUSIC_PREFIX);
        genTypes.put("doc", GEN_DOCUMENT_PREFIX);
        genTypes.put("docx", GEN_DOCUMENT_PREFIX);
        genTypes.put("xls", GEN_DOCUMENT_PREFIX);
        genTypes.put("xlsx", GEN_DOCUMENT_PREFIX);
        genTypes.put("pdf", GEN_DOCUMENT_PREFIX);
        df = new SimpleDateFormat("yyyyMMddSSS");
        sdfFilePath = new SimpleDateFormat("yyyy" + File.separator + "MM");
    }
}

