/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils;

import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;

public class MGL_DateTimeUtils {
    public static int calculateAge(LocalDate birthDate) {
        LocalDate currentDate = LocalDate.now();
        if (birthDate != null && birthDate.isBefore(currentDate)) {
            return Period.between(birthDate, currentDate).getYears();
        }
        throw new IllegalArgumentException("\u7ed9\u5b9a\u65e5\u671f\u65e0\u6548\u6216\u5728\u672a\u6765\u65e5\u671f");
    }

    public static int calculateAge(Date birthDate) {
        if (birthDate == null) {
            throw new IllegalArgumentException("\u7ed9\u5b9a\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LocalDate birthLocalDate = MGL_DateTimeUtils.convertToLocalDate(birthDate);
        return MGL_DateTimeUtils.calculateAge(birthLocalDate);
    }

    public static int getMonths(Date startDate, Date endDate) {
        LocalDate startLocalDate = MGL_DateTimeUtils.convertToLocalDate(startDate);
        LocalDate endLocalDate = MGL_DateTimeUtils.convertToLocalDate(endDate);
        return MGL_DateTimeUtils.getMonths(endLocalDate, endLocalDate);
    }

    public static int getMonths(LocalDate startDate, LocalDate endDate) {
        Period period = Period.between(startDate, endDate);
        return period.getYears() * 12 + period.getMonths();
    }

    public static long getDays(Date startDate, Date endDate) {
        LocalDate startLocalDate = MGL_DateTimeUtils.convertToLocalDate(startDate);
        LocalDate endLocalDate = MGL_DateTimeUtils.convertToLocalDate(endDate);
        return MGL_DateTimeUtils.getDays(startLocalDate, endLocalDate);
    }

    public static long getDays(LocalDate startDate, LocalDate endDate) {
        return ChronoUnit.DAYS.between(startDate, endDate);
    }

    public static long getInterval(LocalDateTime start, LocalDateTime end) {
        return MGL_DateTimeUtils.getInterval(start, end, TimeUnit.SECONDS);
    }

    public static long getInterval(LocalDateTime start, LocalDateTime end, TimeUnit unit) {
        if (start == null || end == null || unit == null) {
            return -1L;
        }
        Duration duration = Duration.between(start, end);
        return switch (unit.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> duration.getSeconds();
            case 1 -> duration.toMinutes();
            case 2 -> duration.toHours();
            case 3 -> duration.toDays();
        };
    }

    public static long getInterval(Date start, Date end) {
        return MGL_DateTimeUtils.getInterval(start, end, TimeUnit.SECONDS);
    }

    public static long getInterval(Date start, Date end, TimeUnit unit) {
        if (start == null || end == null || unit == null) {
            return -1L;
        }
        LocalDateTime startDateTime = MGL_DateTimeUtils.convertToLocalDateTime(start);
        LocalDateTime endDateTime = MGL_DateTimeUtils.convertToLocalDateTime(end);
        return MGL_DateTimeUtils.getInterval(startDateTime, endDateTime, unit);
    }

    public static LocalDateTime convertToLocalDateTime(Date dateTime) {
        if (dateTime == null) {
            throw new IllegalArgumentException("Date \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dateTime instanceof java.sql.Date) {
            java.sql.Date date = (java.sql.Date)dateTime;
            return date.toLocalDate().atStartOfDay(ZoneId.systemDefault()).toLocalDateTime();
        }
        System.out.println("time----------------");
        return Instant.ofEpochMilli(dateTime.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static Date convertToDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate convertToLocalDate(Date date) {
        if (date instanceof java.sql.Date) {
            java.sql.Date d = (java.sql.Date)date;
            return d.toLocalDate().atStartOfDay(ZoneId.systemDefault()).toLocalDate();
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static void main(String[] args) {
        LocalDateTime start = LocalDateTime.of(2023, 11, 1, 10, 0, 0);
        LocalDateTime end = LocalDateTime.of(2023, 11, 2, 10, 0, 1);
        System.out.println("LocalDateTime\u95f4\u9694\u79d2\u6570: " + MGL_DateTimeUtils.getInterval(start, end, TimeUnit.SECONDS));
        System.out.println("LocalDateTime\u95f4\u9694\u5c0f\u65f6: " + MGL_DateTimeUtils.getInterval(start, end, TimeUnit.HOURS));
        Date dateStart = new Date();
        Date dateEnd = new Date();
        System.out.println(MGL_DateTimeUtils.convertToLocalDateTime(new Date()));
        System.out.println("Date\u5bf9\u8c61\u95f4\u9694\u79d2\u6570: " + MGL_DateTimeUtils.getInterval(dateStart, dateEnd, TimeUnit.SECONDS));
        System.out.println("Date\u5bf9\u8c61\u95f4\u9694\u5c0f\u65f6: " + MGL_DateTimeUtils.getInterval(dateStart, dateEnd, TimeUnit.HOURS));
        java.sql.Date sqlDate = java.sql.Date.valueOf(LocalDate.now());
        MGL_DateTimeUtils.convertToLocalDateTime(Timestamp.valueOf(LocalDateTime.now()));
    }

    public static enum TimeUnit {
        SECONDS,
        MINUTES,
        HOURS,
        DAYS;

    }
}

