/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.Pipe;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.utils.FileNameUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.core.utils.MGL_Asserts;
import tech.mgl.core.utils.MGL_FileUtils;
import tech.mgl.core.utils.MGL_ObjectUtils;
import tech.mgl.core.utils.MGL_StringUtils;
import tech.mgl.exception.GlobalException;
import tech.mgl.utils.MGL_FileNameUtils;

public class MGL_CompressUtils {
    private static final int BUFFER_SIZE = 2048;
    private static final Logger logger = LoggerFactory.getLogger(MGL_CompressUtils.class);
    private final FileType type;
    private final String destPath;
    private final String srcPath;
    private final List<File> selectFiles;
    private FileType t;

    public MGL_CompressUtils(Builder builder) {
        this.type = builder.getType();
        this.selectFiles = builder.getSelectFiles();
        this.srcPath = builder.getFilePath();
        this.destPath = builder.getOutPath();
    }

    public FileType getType() {
        return this.type;
    }

    public String getDestPath() {
        return this.destPath;
    }

    public String getSrcPath() {
        return this.srcPath;
    }

    public List<File> getSelectFiles() {
        return this.selectFiles;
    }

    private static void com() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> unTar(InputStream inputStream, String destDir) throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        try (TarArchiveInputStream tarIn = new TarArchiveInputStream(inputStream, 2048);){
            TarArchiveEntry entry;
            while ((entry = tarIn.getNextTarEntry()) != null) {
                fileNames.add(entry.getName());
                if (entry.isDirectory()) {
                    MGL_CompressUtils.createDirectory(destDir, entry.getName());
                    continue;
                }
                File tmpFile = new File(destDir + File.separator + entry.getName());
                MGL_CompressUtils.createDirectory(tmpFile.getParent() + File.separator, null);
                FileOutputStream out = null;
                try {
                    int length;
                    out = new FileOutputStream(tmpFile);
                    byte[] b = new byte[2048];
                    while ((length = tarIn.read(b)) != -1) {
                        ((OutputStream)out).write(b, 0, length);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    assert (out != null);
                    out.flush();
                    ((OutputStream)out).close();
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return fileNames;
    }

    private List<String> unTar(String tarFile, String destDir) throws Exception {
        File file = new File(tarFile);
        return this.unTar(file, destDir);
    }

    private List<String> unTar(File tarFile, String destDir) throws Exception {
        if (StringUtils.isBlank((CharSequence)destDir)) {
            destDir = tarFile.getParent();
        }
        destDir = destDir.endsWith(File.separator) ? destDir : destDir + File.separator;
        return MGL_CompressUtils.unTar(new FileInputStream(tarFile), destDir);
    }

    private List<String> unTarBZip2(File tarFile, String destDir) throws Exception {
        if (StringUtils.isBlank((CharSequence)destDir)) {
            destDir = tarFile.getParent();
        }
        destDir = destDir.endsWith(File.separator) ? destDir : destDir + File.separator;
        return MGL_CompressUtils.unTar((InputStream)new BZip2CompressorInputStream((InputStream)new FileInputStream(tarFile)), destDir);
    }

    private List<String> unTarBZip2(String file, String destDir) throws Exception {
        File tarFile = new File(file);
        return this.unTarBZip2(tarFile, destDir);
    }

    private List<String> unBZip2(String bzip2File, String destDir) throws IOException {
        File file = new File(bzip2File);
        return this.unBZip2(file, destDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> unBZip2(File srcFile, String destDir) throws IOException {
        if (StringUtils.isBlank((CharSequence)destDir)) {
            destDir = srcFile.getParent();
        }
        destDir = destDir.endsWith(File.separator) ? destDir : destDir + File.separator;
        ArrayList<String> fileNames = new ArrayList<String>();
        InputStream is = null;
        OutputStream os = null;
        try {
            File destFile = new File(destDir, FileNameUtils.getBaseName((String)srcFile.toString()));
            fileNames.add(FileNameUtils.getBaseName((String)srcFile.toString()));
            is = new BZip2CompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(srcFile), 2048));
            os = new BufferedOutputStream(new FileOutputStream(destFile), 2048);
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            if (null != os) {
                os.flush();
                os.close();
            }
            if (null != is) {
                is.close();
            }
        }
        return fileNames;
    }

    private List<String> unGZ(String gzFile, String destDir) throws IOException {
        File file = new File(gzFile);
        return this.unGZ(file, destDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> unGZ(File srcFile, String destDir) throws IOException {
        if (StringUtils.isBlank((CharSequence)destDir)) {
            destDir = srcFile.getParent();
        }
        destDir = destDir.endsWith(File.separator) ? destDir : destDir + File.separator;
        ArrayList<String> fileNames = new ArrayList<String>();
        InputStream is = null;
        OutputStream os = null;
        try {
            File destFile = new File(destDir, FileNameUtils.getBaseName((String)srcFile.toString()));
            fileNames.add(FileNameUtils.getBaseName((String)srcFile.toString()));
            is = new GzipCompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(srcFile), 2048));
            os = new BufferedOutputStream(new FileOutputStream(destFile), 2048);
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            if (null != os) {
                os.flush();
                os.close();
            }
            if (null != is) {
                is.close();
            }
        }
        return fileNames;
    }

    private List<String> unTarGZ(File tarFile, String destDir) throws Exception {
        if (StringUtils.isBlank((CharSequence)destDir)) {
            destDir = tarFile.getParent();
        }
        destDir = destDir.endsWith(File.separator) ? destDir : destDir + File.separator;
        return MGL_CompressUtils.unTar((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(tarFile)), destDir);
    }

    private List<String> unTarGZ(String file, String destDir) throws Exception {
        File tarFile = new File(file);
        return this.unTarGZ(tarFile, destDir);
    }

    private static void createDirectory(String outputDir, String subDir) {
        File file = new File(outputDir);
        if (subDir != null && !subDir.trim().isEmpty()) {
            file = new File(outputDir + File.separator + subDir);
        }
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> unZip(File zipfile, String destDir) throws IOException {
        if (StringUtils.isBlank((CharSequence)destDir)) {
            destDir = zipfile.getParent();
        }
        destDir = destDir.endsWith(File.separator) ? destDir : destDir + File.separator;
        ZipArchiveInputStream is = null;
        ArrayList<String> fileNames = new ArrayList<String>();
        try {
            is = new ZipArchiveInputStream((InputStream)new BufferedInputStream(new FileInputStream(zipfile), 2048));
            ZipArchiveEntry entry = null;
            while ((entry = is.getNextZipEntry()) != null) {
                fileNames.add(entry.getName());
                if (entry.isDirectory()) {
                    File directory = new File(destDir, entry.getName());
                    directory.mkdirs();
                    continue;
                }
                OutputStream os = null;
                try {
                    os = new BufferedOutputStream(new FileOutputStream(new File(destDir, entry.getName())), 2048);
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                finally {
                    if (null == os) continue;
                    os.flush();
                    os.close();
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != is) {
                is.close();
            }
        }
        return fileNames;
    }

    private List<String> unZip(String zipFile, String destDir) {
        try {
            File zipFileTemp = new File(zipFile);
            return this.unZip(zipFileTemp, destDir);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void compressZip(File filePath, String outPath) throws Exception {
        MGL_CompressUtils.compressZip(filePath, null, outPath);
    }

    private void compressZip(List<File> files, String outPath) throws Exception {
        if (null == files || files.isEmpty()) {
            throw new GlobalException("\u6ca1\u6709\u6307\u5b9a\u538b\u7f29\u6587\u4ef6", true);
        }
        File[] a = new File[files.size()];
        files.toArray(a);
        MGL_CompressUtils.compressZip(null, a, outPath);
    }

    private void compressZip(File[] files, String outPath) throws Exception {
        MGL_CompressUtils.compressZip(null, files, outPath);
    }

    private void compressRecursiveZip(String src, String outPath) {
        MGL_Asserts.notBlank(src, "\u6307\u5b9a\u538b\u7f29\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u4e0d\u80fd\u4e3a\u7a7a");
        MGL_Asserts.notBlank(outPath, "\u8f93\u51fa\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private static void compressZip(File oneFile, File[] files, String outPath) throws Exception {
        if (StringUtils.isBlank((CharSequence)outPath)) {
            throw new NullPointerException("outPath \u4e0d\u80fd\u4e3a\u7a7a");
        }
        File zipFile = new File(outPath);
        if (!zipFile.exists()) {
            zipFile.getParentFile().mkdirs();
        }
        try (ZipArchiveOutputStream zipOutput = (ZipArchiveOutputStream)new ArchiveStreamFactory().createArchiveOutputStream("zip", (OutputStream)new FileOutputStream(zipFile));){
            zipOutput.setEncoding("UTF-8");
            zipOutput.setUseZip64(Zip64Mode.AsNeeded);
            zipOutput.setComment("\u538b\u7f29");
            WritableByteChannel writableByteChannel = Channels.newChannel((OutputStream)zipOutput);
            if (oneFile != null) {
                if (!oneFile.exists()) {
                    return;
                }
                if (oneFile.isDirectory()) {
                    String rootPath = oneFile.getAbsolutePath();
                    new Entry().setDg(true).setOneFile(oneFile).setZipOutput(zipOutput).setWritableByteChannel(writableByteChannel).setRootPath(rootPath).put();
                } else {
                    MGL_CompressUtils.zipArchive(oneFile.getParentFile().getAbsolutePath(), oneFile, zipOutput, writableByteChannel);
                }
            } else if (files != null && files.length > 0) {
                File first = files[0];
                String rootPath = first.getParentFile().getAbsolutePath();
                if (first.isDirectory()) {
                    rootPath = first.getParentFile().getAbsolutePath();
                }
                for (File file : files) {
                    MGL_CompressUtils.zipArchive(rootPath, file, zipOutput, writableByteChannel);
                }
            }
            writableByteChannel.close();
            zipOutput.flush();
            zipOutput.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private static void zipArchive(String rootPath, File oneFile, ZipArchiveOutputStream zipOutput, WritableByteChannel writableByteChannel) throws IOException {
        if (oneFile == null || !oneFile.exists()) {
            return;
        }
        Object rp = oneFile.getAbsolutePath().replace(rootPath, "").replaceAll("\\\\", "/");
        if (((String)rp).startsWith("/")) {
            rp = ((String)rp).replaceFirst("/", "");
        }
        if (oneFile.isDirectory()) {
            rp = (String)rp + "/";
        }
        ZipArchiveEntry entry = new ZipArchiveEntry(oneFile, (String)rp);
        zipOutput.putArchiveEntry(entry);
        if (oneFile.isFile()) {
            try (FileInputStream fileInputStream = new FileInputStream(oneFile);
                 FileChannel channel = fileInputStream.getChannel();){
                channel.transferTo(0L, oneFile.length(), writableByteChannel);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        zipOutput.closeArchiveEntry();
    }

    private static void zipFilePip(File oneFile, String outPath) {
        long beginTime = System.currentTimeMillis();
        try (WritableByteChannel out = Channels.newChannel(new FileOutputStream(outPath));){
            Pipe pipe = Pipe.open();
            CompletableFuture.runAsync(() -> MGL_CompressUtils.runTask(pipe, oneFile));
            Pipe.SourceChannel readableByteChannel = pipe.source();
            ByteBuffer buffer = ByteBuffer.allocate(0x3200000);
            out.write(buffer);
            readableByteChannel.close();
            out.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void runTask(Pipe pipe, File oneFile) {
        try (ZipOutputStream zos = new ZipOutputStream(Channels.newOutputStream(pipe.sink()));
             WritableByteChannel out = Channels.newChannel(zos);){
            ZipArchiveEntry entry = new ZipArchiveEntry(oneFile, oneFile.getName());
            zos.putNextEntry((ZipEntry)entry);
            try (FileInputStream fileInputStream = new FileInputStream(oneFile);
                 FileChannel jpgChannel = fileInputStream.getChannel();){
                jpgChannel.transferTo(0L, oneFile.length(), out);
                jpgChannel.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static void tar(String srcPath, String destPath) {
        String t = destPath;
        File folderToTar = new File(srcPath);
        if (MGL_StringUtils.isBlank((CharSequence)t)) {
            t = folderToTar.getParent();
        }
        File destFIle = new File(t);
        if (!t.toLowerCase().endsWith(".tar")) {
            t = t.concat(destFIle.getName().concat(".tar"));
        }
        try (TarArchiveOutputStream archive = new TarArchiveOutputStream((OutputStream)new FileOutputStream(t));){
            MGL_FileUtils.getAll(folderToTar.getAbsolutePath()).forEach(p -> {
                File file = p.toFile();
                if (!file.isDirectory()) {
                    System.out.println("Taring file - " + String.valueOf(file));
                    TarArchiveEntry entry_1 = new TarArchiveEntry(file, file.toString());
                    try (FileInputStream fis = new FileInputStream(file);){
                        archive.putArchiveEntry(entry_1);
                        IOUtils.copy((InputStream)fis, (OutputStream)archive);
                        archive.closeArchiveEntry();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
            archive.finish();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compress() {
        MGL_Asserts.notBlank(this.srcPath, "\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        FileType t = this.getType();
        if (MGL_ObjectUtils.isEmpty(this.getType())) {
            MGL_Asserts.notBlank(MGL_FileNameUtils.getExtension(this.srcPath), "\u6587\u4ef6\u7c7b\u578b\u6216\u8005\u540e\u7f00\u4e0d\u80fd\u4e3a\u7a7a");
            t = FileType.valueOf(MGL_FileNameUtils.getExtension(this.srcPath));
        }
        try {
            String destDir = this.getDestPath();
            File srcFile = MGL_FileUtils.getFileCreate(this.srcPath);
            if (StringUtils.isBlank((CharSequence)destDir)) {
                assert (srcFile != null);
                destDir = srcFile.getParent();
            }
            destDir = destDir.endsWith(File.separator) ? destDir : destDir + File.separator;
            InputStream is = null;
            OutputStream os = null;
            try {
                assert (srcFile != null);
                File destFile = new File(destDir, FileNameUtils.getBaseName((String)srcFile.toString()));
                switch (t.ordinal()) {
                    case 0: {
                        this.compressZip(new File(this.srcPath), this.destPath);
                        break;
                    }
                    case 5: {
                        is = new BufferedInputStream(new FileInputStream(srcFile), 2048);
                        os = new GzipCompressorOutputStream((OutputStream)new GzipCompressorOutputStream((OutputStream)new FileOutputStream(srcFile)));
                    }
                    case 4: {
                        this.unTarGZ(this.srcPath, this.destPath);
                    }
                    case 1: {
                        MGL_CompressUtils.tar(this.srcPath, this.destPath);
                    }
                    case 3: {
                        this.unBZip2(this.srcPath, this.destPath);
                    }
                    case 2: {
                        this.unTarBZip2(this.srcPath, this.destPath);
                    }
                    default: {
                        this.compressZip(new File(this.srcPath), this.destPath);
                    }
                }
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                if (null != os) {
                    os.flush();
                    os.close();
                }
                if (null != is) {
                    is.close();
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public List<String> un() {
        MGL_Asserts.notBlank(this.srcPath, "\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        FileType t = this.getType();
        if (MGL_ObjectUtils.isEmpty(this.getType())) {
            MGL_Asserts.notBlank(MGL_FileNameUtils.getExtension(this.srcPath), "\u6587\u4ef6\u7c7b\u578b\u6216\u8005\u540e\u7f00\u4e0d\u80fd\u4e3a\u7a7a");
            t = FileType.valueOf(MGL_FileNameUtils.getExtension(this.srcPath));
        }
        try {
            return switch (t.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.unZip(this.srcPath, this.destPath);
                case 5 -> this.unGZ(this.srcPath, this.destPath);
                case 4 -> this.unTarGZ(this.srcPath, this.destPath);
                case 1 -> this.unTar(this.srcPath, this.destPath);
                case 3 -> this.unBZip2(this.srcPath, this.destPath);
                case 2 -> this.unTarBZip2(this.srcPath, this.destPath);
            };
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static void zipEntry(String rootPath, File oneFile, ZipOutputStream zipOutput, WritableByteChannel writableByteChannel) throws IOException {
        if (oneFile == null || !oneFile.exists()) {
            return;
        }
        Object rp = oneFile.getAbsolutePath().replace(rootPath, "").replaceAll("\\\\", "/");
        if (((String)rp).startsWith("/")) {
            rp = ((String)rp).replaceFirst("/", "");
        }
        if (oneFile.isDirectory()) {
            rp = (String)rp + "/";
        }
        ZipEntry entry = new ZipEntry((String)rp);
        zipOutput.putNextEntry(entry);
        if (oneFile.isFile()) {
            try (FileInputStream fileInputStream = new FileInputStream(oneFile);
                 FileChannel channel = fileInputStream.getChannel();){
                channel.transferTo(0L, oneFile.length(), writableByteChannel);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static class Builder {
        private FileType type;
        private String outPath;
        private String filePath;
        private List<File> selectFiles;

        public FileType getType() {
            return this.type;
        }

        public Builder setType(FileType type) {
            this.type = type;
            return this;
        }

        public MGL_CompressUtils build() {
            return new MGL_CompressUtils(this);
        }

        public String getOutPath() {
            return this.outPath;
        }

        public Builder setOutPath(String outPath) {
            this.outPath = outPath;
            return this;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public Builder setFilePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public List<File> getSelectFiles() {
            return this.selectFiles;
        }

        public Builder setSelectFiles(List<File> selectFiles) {
            this.selectFiles = selectFiles;
            return this;
        }
    }

    public static enum FileType {
        ZIP("ZIP"),
        TAR("TAR"),
        TARBZ2("TAR.BZ2"),
        BZ2("BZ2"),
        TARGZ("TAR.GZ"),
        GZ("GZ");

        private String type;

        private FileType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    static class Entry {
        private boolean dg = false;
        private String rootPath;
        private File oneFile;
        private ZipArchiveOutputStream zipOutput;
        private WritableByteChannel writableByteChannel;

        public boolean isDg() {
            return this.dg;
        }

        public Entry setDg(boolean dg) {
            this.dg = dg;
            return this;
        }

        public String getRootPath() {
            return this.rootPath;
        }

        public Entry setRootPath(String rootPath) {
            this.rootPath = rootPath;
            return this;
        }

        public File getOneFile() {
            return this.oneFile;
        }

        public Entry setOneFile(File oneFile) {
            this.oneFile = oneFile;
            return this;
        }

        public ZipArchiveOutputStream getZipOutput() {
            return this.zipOutput;
        }

        public Entry setZipOutput(ZipArchiveOutputStream zipOutput) {
            this.zipOutput = zipOutput;
            return this;
        }

        public WritableByteChannel getWritableByteChannel() {
            return this.writableByteChannel;
        }

        public Entry setWritableByteChannel(WritableByteChannel writableByteChannel) {
            this.writableByteChannel = writableByteChannel;
            return this;
        }

        public void put() throws IOException {
            if (this.oneFile == null || !this.oneFile.exists()) {
                return;
            }
            Object rp = this.oneFile.getAbsolutePath().replace(this.rootPath, "").replaceAll("\\\\", "/");
            if (((String)rp).startsWith("/")) {
                rp = ((String)rp).replaceFirst("/", "");
            }
            if (this.oneFile.isDirectory()) {
                rp = (String)rp + "/";
            }
            if (this.oneFile.isDirectory() && this.dg && null != this.oneFile.list() && this.oneFile.list().length > 0) {
                File[] fileArray = this.oneFile.listFiles();
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    File file;
                    this.oneFile = file = fileArray[i];
                    this.put();
                }
                return;
            }
            ZipArchiveEntry entry = new ZipArchiveEntry(this.oneFile, (String)rp);
            this.zipOutput.putArchiveEntry(entry);
            if (this.oneFile.isFile()) {
                try (FileInputStream fileInputStream = new FileInputStream(this.oneFile);
                     FileChannel channel = fileInputStream.getChannel();){
                    channel.transferTo(0L, this.oneFile.length(), this.writableByteChannel);
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            this.zipOutput.closeArchiveEntry();
        }
    }
}

