/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.compress.utils.FileNameUtils;

public class MGL_CompressPicUtils {
    public static synchronized boolean compressPic(String oldPicPath, String newPicPath, int outputWidth, int outputHeight) {
        return MGL_CompressPicUtils.compress(oldPicPath, newPicPath, outputWidth, outputHeight, false);
    }

    public static synchronized boolean compressWidth(String oldPicPath, String newPicPath, int outputWidth) {
        return MGL_CompressPicUtils.compress(oldPicPath, newPicPath, outputWidth, null, false);
    }

    public static synchronized boolean compressHeight(String oldPicPath, String newPicPath, int outputHeight) {
        return MGL_CompressPicUtils.compress(oldPicPath, newPicPath, null, outputHeight, false);
    }

    public static synchronized boolean compressPic(String oldPicPath, String newPicPath) {
        return MGL_CompressPicUtils.compress(oldPicPath, newPicPath, 100, 100, true);
    }

    public static synchronized boolean compress(String oldPicPath, String newPicPath, Integer outputWidth, Integer outputHeight, boolean proportion) {
        try {
            int newHeight;
            int newWidth;
            File file = new File(oldPicPath);
            if (!file.exists()) {
                throw new NullPointerException("\u539f\u56fe\u7247\u4e0d\u5b58\u5728!");
            }
            BufferedImage img = ImageIO.read(file);
            if (((Image)img).getWidth(null) == -1) {
                System.out.println(" can't read,retry!<BR>");
                return false;
            }
            if (proportion) {
                double rate1 = (double)((Image)img).getWidth(null) / (double)outputWidth.intValue() + 0.1;
                double rate2 = (double)((Image)img).getHeight(null) / (double)outputHeight.intValue() + 0.1;
                double rate = Math.max(rate1, rate2);
                newWidth = (int)((double)((Image)img).getWidth(null) / rate);
                newHeight = (int)((double)((Image)img).getHeight(null) / rate);
            } else if (outputHeight == null) {
                rate = (double)((Image)img).getHeight(null) / (double)((Image)img).getWidth(null);
                newHeight = (int)(rate * (double)outputWidth.intValue());
                newWidth = outputWidth;
            } else if (outputWidth == null) {
                rate = (double)((Image)img).getHeight(null) / (double)((Image)img).getWidth(null);
                newWidth = (int)((double)outputHeight.intValue() / rate);
                newHeight = outputHeight;
            } else {
                newWidth = outputWidth;
                newHeight = outputHeight;
            }
            BufferedImage to = new BufferedImage(newWidth, newHeight, 1);
            File f = new File(newPicPath);
            if (!f.exists()) {
                f.mkdirs();
            }
            if (newPicPath.endsWith("png")) {
                Graphics2D g2d = to.createGraphics();
                to = g2d.getDeviceConfiguration().createCompatibleImage(newWidth, newHeight, 3);
                g2d.dispose();
                g2d = to.createGraphics();
                Image from = img.getScaledInstance(newWidth, newHeight, 16);
                g2d.drawImage(from, 0, 0, null);
                g2d.dispose();
                ImageIO.write((RenderedImage)to, "png", f);
                from.flush();
            } else {
                to.getGraphics().drawImage(img.getScaledInstance(newWidth, newHeight, 4), 0, 0, null);
                ImageIO.write((RenderedImage)to, FileNameUtils.getExtension((String)newPicPath), f);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        long l = System.currentTimeMillis();
        System.out.println(MGL_CompressPicUtils.compress("G:\\Photos\\61d7d32748a18848d7a6596f0075fad27175ec71_1.png", "F:\\Desktop\\pic\\IMG_2016060911814654616751180NPF----com.png", 900, 800, true));
        System.out.println(MGL_CompressPicUtils.compressWidth("G:\\Photos\\34fae6cd7b899e51476694d940a7d933c9950d16.jpg", "F:\\Desktop\\pic\\IMG_2016060911814654616751180NPF----com1.jpg", 300));
        System.out.println(MGL_CompressPicUtils.compressHeight("G:\\Photos\\61d7d32748a18848d7a6596f0075fad27175ec71_1.png", "F:\\Desktop\\pic\\IMG_2016060911814654616751180NPF----com2.png", 300));
        System.out.println("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - l) / 1000.0f + " \u79d2 ");
        l = System.currentTimeMillis();
        System.out.println("\r<br>\u6267\u884c\u8017\u65f6 : " + (float)(System.currentTimeMillis() - l) / 1000.0f + " \u79d2 ");
    }

    private static boolean resizeImage(String imageFullPath, String outPaht, int maxEdgeLength) throws Exception {
        int height;
        boolean isWidthLonger;
        File file = new File(imageFullPath);
        if (!file.exists()) {
            return false;
        }
        BufferedImage img = ImageIO.read(file);
        if (img == null || ((Image)img).getWidth(null) <= 0 || ((Image)img).getHeight(null) <= 0) {
            return false;
        }
        int width = ((Image)img).getWidth(null);
        boolean bl = isWidthLonger = width > (height = ((Image)img).getHeight(null));
        if (width > maxEdgeLength || height > maxEdgeLength) {
            if (isWidthLonger) {
                ratio = (double)maxEdgeLength / (double)width;
                width = maxEdgeLength;
                height = Double.valueOf(Math.floor(ratio * (double)height)).intValue();
            } else {
                ratio = (double)maxEdgeLength / (double)height;
                width = Double.valueOf(Math.floor(ratio * (double)width)).intValue();
                height = maxEdgeLength;
            }
        } else {
            return true;
        }
        try (FileOutputStream out = null;){
            BufferedImage tag = new BufferedImage(width, height, 1);
            tag.getGraphics().drawImage(img.getScaledInstance(width, height, 4), 0, 0, null);
            out = new FileOutputStream(outPaht);
            ImageIO.write((RenderedImage)tag, "jpg", out);
        }
        return true;
    }
}

