/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils;

import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.core.i.MFunction;

public class MGL_ClassUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)MGL_ClassUtils.class.getSimpleName());

    public static boolean isPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (IllegalAccessError err) {
            throw new IllegalStateException("Readability mismatch in inheritance hierarchy of class [" + className + "]: " + err.getMessage(), err);
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static <T> String getFieldName(MFunction<T, ?> function) {
        try {
            Method writeReplace = function.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            writeReplace.setAccessible(true);
            SerializedLambda serializedLambda = (SerializedLambda)writeReplace.invoke(function, new Object[0]);
            String methodName = serializedLambda.getImplMethodName();
            if (methodName.startsWith("get") && methodName.length() > 3) {
                return Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            }
            if (methodName.startsWith("is") && methodName.length() > 2) {
                return Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3);
            }
            throw new IllegalArgumentException("The method is not a valid getter: " + methodName);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to extract field name", e);
        }
    }

    public static String toUnderlineCase(String camelCase) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < camelCase.length(); ++i) {
            char ch = camelCase.charAt(i);
            if (Character.isUpperCase(ch)) {
                if (i > 0) {
                    result.append('_');
                }
                result.append(Character.toLowerCase(ch));
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    public static <T> String getDbColumnName(MFunction<T, ?> function) {
        String fieldName = MGL_ClassUtils.getFieldName(function);
        return MGL_ClassUtils.toUnderlineCase(fieldName);
    }
}

