/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils;

import java.util.StringJoiner;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.core.utils.MGL_StringUtils;

public class MGL_ChineseUtils {
    private static final Logger logger = LoggerFactory.getLogger(MGL_ChineseUtils.class);
    private static HanyuPinyinOutputFormat format = null;
    private static String[] pinyin;

    public static synchronized String getChFirstCharacter(String str) {
        return MGL_ChineseUtils.getChFirstCharacter(str, null);
    }

    public static synchronized String getChFirstCharacter(String str, String delimiter) {
        StringBuilder sb = new StringBuilder();
        StringJoiner sj = null;
        if (MGL_StringUtils.isNotBlank((CharSequence)delimiter)) {
            sj = new StringJoiner(delimiter);
        }
        if (StringUtils.isNotBlank((CharSequence)str)) {
            for (int i = 0; i < str.length(); ++i) {
                String tempPinyin = MGL_ChineseUtils.characterToPinYin(str.charAt(i));
                if (tempPinyin == null) {
                    if (null != sj) {
                        sj.add("" + str.charAt(i));
                        continue;
                    }
                    sb.append(str.charAt(i));
                    continue;
                }
                if (null != sj) {
                    sj.add("" + tempPinyin.charAt(0));
                    continue;
                }
                sb.append(tempPinyin.charAt(0));
            }
        }
        if (null != sj) {
            return sj.toString();
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println(MGL_ChineseUtils.getChFirstCharacter("\u4f46\u65f6\u4ee3\u53d1\u751f\u7684", ","));
        System.out.println(MGL_ChineseUtils.stringToPinYin("\u6c34\u7535\u8d39"));
        System.out.println(MGL_ChineseUtils.stringToPinYin("d"));
        System.out.println(MGL_ChineseUtils.stringToPinYin("\u4f60\u597d", ","));
    }

    public static synchronized String stringToPinYin(String str) {
        return MGL_ChineseUtils.stringToPinYin(str, null);
    }

    public static synchronized String stringToPinYin(String str, String delimiter) {
        StringBuilder sb = new StringBuilder();
        StringJoiner stringJoiner = null;
        if (MGL_StringUtils.isNotBlank((CharSequence)delimiter)) {
            stringJoiner = new StringJoiner(delimiter);
        }
        if (StringUtils.isNotBlank((CharSequence)str)) {
            for (int i = 0; i < str.length(); ++i) {
                String tempPinyin = MGL_ChineseUtils.characterToPinYin(str.charAt(i));
                if (tempPinyin == null) {
                    if (null != stringJoiner) {
                        stringJoiner.add("" + str.charAt(i));
                        continue;
                    }
                    sb.append(str.charAt(i));
                    continue;
                }
                if (null != stringJoiner) {
                    stringJoiner.add(tempPinyin);
                    continue;
                }
                sb.append(tempPinyin);
            }
        }
        if (null != stringJoiner) {
            return stringJoiner.toString();
        }
        return sb.toString();
    }

    private MGL_ChineseUtils() {
        format = new HanyuPinyinOutputFormat();
        format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        pinyin = null;
    }

    public static synchronized String characterToPinYin(char c) {
        try {
            pinyin = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)format);
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (pinyin == null || pinyin.length == 0) {
            return null;
        }
        return pinyin[0];
    }

    static {
        format = new HanyuPinyinOutputFormat();
        format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        pinyin = null;
    }
}

