/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils;

import jakarta.persistence.Column;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.core.i.MFunction;
import tech.mgl.core.utils.MGL_ClassUtils;

public class MGL_BeanUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)MGL_BeanUtils.class.getSimpleName());

    public static synchronized <T> T copyAttribute(Object target, Object sourceObj) throws Exception {
        return MGL_BeanUtils.copyAttribute(target, sourceObj, null, false);
    }

    public static synchronized <T> T copyAttribute(Object target, Object sourceObj, List<String> copyFields) throws Exception {
        return MGL_BeanUtils.copyAttribute(target, sourceObj, copyFields, false);
    }

    public static synchronized <T> T copyAttributeWithExclude(Object target, Object sourceObj, List<String> excludeFields) throws Exception {
        return MGL_BeanUtils.copyAttribute(target, sourceObj, null, excludeFields, false);
    }

    public static synchronized <T, V> V convert(T t, Class<V> vClass) throws Exception {
        return (V)MGL_BeanUtils.copyAttribute(vClass, t);
    }

    public static synchronized <T> T copyAttribute(Object target, Object sourceObj, List<String> copyFields, boolean exeSrcNull) throws Exception {
        return MGL_BeanUtils.copyAttribute(target, sourceObj, copyFields, null, exeSrcNull);
    }

    public static synchronized <T> T copyAttribute(Object target, Object sourceObj, List<String> copyFields, List<String> excludeFields, boolean exeSrcNull) throws Exception {
        Object t;
        Class tar;
        if (sourceObj == null || target == null) {
            throw new Exception("\u6e90\u5bf9\u8c61\u548c\u76ee\u6807\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        Class<?> src = sourceObj.getClass();
        if (target instanceof Class) {
            Class cls;
            tar = cls = (Class)target;
            t = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            tar = target.getClass();
            t = target;
        }
        BeanInfo beanInfo = Introspector.getBeanInfo(tar);
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        Map<String, Object> map = MGL_BeanUtils.bean2Map(sourceObj);
        for (PropertyDescriptor descriptor : propertyDescriptors) {
            String propertyName = descriptor.getName();
            if (StringUtils.isBlank((CharSequence)propertyName) || propertyName.equals("class")) continue;
            Method readMethod = descriptor.getReadMethod();
            Method writeMethod = descriptor.getWriteMethod();
            if (null == readMethod || null == writeMethod) continue;
            assert (map != null);
            if (!map.containsKey(propertyName) || "getClass".equals(readMethod.getName())) continue;
            try {
                Column column;
                Object result = src.getMethod(readMethod.getName(), new Class[0]).invoke(sourceObj, new Object[0]);
                if (copyFields != null && !copyFields.isEmpty()) {
                    column = readMethod.getAnnotation(Column.class);
                    if (!copyFields.contains(propertyName) && (null == column || !copyFields.contains(column.name()))) continue;
                    MGL_BeanUtils.invokeMethod(t, exeSrcNull, writeMethod, result);
                    continue;
                }
                if (excludeFields != null && !excludeFields.isEmpty()) {
                    column = readMethod.getAnnotation(Column.class);
                    if (excludeFields.contains(propertyName) || null != column && excludeFields.contains(column.name())) continue;
                }
                MGL_BeanUtils.invokeMethod(t, exeSrcNull, writeMethod, result);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new Exception("\u9519\u8bef\u5b57\u6bb5\uff1a" + readMethod.getName(), e);
            }
        }
        return (T)t;
    }

    private static void invokeMethod(Object targetObj, boolean exeSrcNull, Method writeMethod, Object result) throws IllegalAccessException, InvocationTargetException {
        if (result != null && null != result.toString() && !result.toString().trim().isEmpty()) {
            writeMethod.invoke(targetObj, result);
        } else if (exeSrcNull) {
            writeMethod.invoke(targetObj, result);
        }
    }

    public static synchronized List<Object> bean2List(Object beanInstance, String[] exceptionField) {
        if (beanInstance == null) {
            return null;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        try {
            Field[] fields;
            Class<?> clazz = beanInstance.getClass();
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!field.getType().equals(String.class) || exceptionField != null && ArrayUtils.contains((Object[])exceptionField, (Object)field.getName())) continue;
                field.setAccessible(true);
                params.add(field.get(beanInstance));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return params;
    }

    public static <T> Map<String, Object> toMap(T bean, boolean keepNull) {
        try {
            PropertyDescriptor[] propertyDescriptors;
            Class<?> type = bean.getClass();
            HashMap<String, Object> returnMap = new HashMap<String, Object>();
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            for (PropertyDescriptor descriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                Method readMethod;
                Object result;
                String propertyName = descriptor.getName();
                if (propertyName.equals("class") || (result = (readMethod = descriptor.getReadMethod()).invoke(bean, new Object[0])) == null || null == result.toString() || result.toString().trim().isEmpty()) continue;
                returnMap.put(propertyName, result);
            }
            return returnMap;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T map2Bean(Map<String, Object> map, Class<T> type) {
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            T t = type.getConstructor(new Class[0]).newInstance(new Object[0]);
            logger.info("convertToBean");
            for (PropertyDescriptor descriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                Object value;
                String propertyName = descriptor.getName();
                if (!map.containsKey(propertyName) || (value = map.get(propertyName)) == null) continue;
                Object[] args = new Object[]{value};
                descriptor.getWriteMethod().invoke(t, args);
            }
            return t;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T mapToBean(Map<String, String> map, Class<T> type) {
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(type);
            T t = type.getConstructor(new Class[0]).newInstance(new Object[0]);
            logger.info("convertToBean");
            for (PropertyDescriptor descriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String value;
                String propertyName = descriptor.getName();
                if (!map.containsKey(propertyName) || !StringUtils.isNotBlank((CharSequence)(value = map.get(propertyName)))) continue;
                descriptor.getWriteMethod().invoke(t, value);
            }
            return t;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> Map<String, Object> bean2Map(T t) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(t.getClass());
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            HashMap<String, Object> mpa = new HashMap<String, Object>(0);
            for (PropertyDescriptor descriptor : propertyDescriptors) {
                String propertyName = descriptor.getName();
                if (propertyName.equals("class")) continue;
                mpa.put(propertyName, descriptor.getReadMethod().invoke(t, new Object[0]));
            }
            return mpa;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T setValues(T t, Map<String, Object> values, boolean copyDBFiled) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        BeanInfo beanInfo = Introspector.getBeanInfo(t.getClass());
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        HashMap mpa = new HashMap(0);
        for (PropertyDescriptor descriptor : propertyDescriptors) {
            String propertyName = descriptor.getName();
            Object value = values.get(propertyName);
            if (null == value) continue;
            descriptor.getWriteMethod().invoke(t, value);
        }
        return t;
    }

    public static <T> T setValues(T t, Map<String, Object> values) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        return MGL_BeanUtils.setValues(t, values, false);
    }

    public static <T, R> R getValue(T t, MFunction<T, R> fieldName) {
        return MGL_BeanUtils.getValueWithDefault(t, MGL_ClassUtils.getFieldName(fieldName), null);
    }

    public static <T, R> R getValueWithDefault(T t, MFunction<T, ?> fieldName, R defaultValue) {
        return MGL_BeanUtils.getValueWithDefault(t, MGL_ClassUtils.getFieldName(fieldName), defaultValue);
    }

    public static <T> Object getValue(T t, String fieldName) {
        return MGL_BeanUtils.getValueWithDefault(t, fieldName, null);
    }

    public static <T, R> R getValueWithDefault(T t, String fieldName, R defaultValue) {
        if (t == null || fieldName == null || fieldName.isEmpty()) {
            throw new IllegalArgumentException("\u5bf9\u8c61\u548c\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Class<?> clazz = t.getClass();
        try {
            Field field = MGL_BeanUtils.getField(clazz, fieldName);
            if (field == null) {
                throw new NoSuchFieldException("\u7c7b " + clazz.getName() + " \u4e2d\u672a\u627e\u5230\u5b57\u6bb5 " + fieldName);
            }
            field.setAccessible(true);
            Object o = field.get(t);
            return (R)(o == null ? defaultValue : o);
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
            return defaultValue;
        }
    }

    private static Field getField(Class<?> clazz, String fieldName) {
        while (clazz != null) {
            try {
                return clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }

    public static String bean2StringValues(Object bean) throws Exception {
        return MGL_BeanUtils.bean2StringValues(bean, null);
    }

    public static <T> T getBean(Object object, Class<T> clS) {
        try {
            T t = clS.getConstructor(new Class[0]).newInstance(new Object[0]);
            MGL_BeanUtils.copyAttribute(t, object);
            return t;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String bean2StringValues(Object bean, String dateFormat) throws Exception {
        BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
        PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (PropertyDescriptor pd : pds) {
            Object value;
            Method m = pd.getReadMethod();
            if (pd.getName().equals("class") || null == (value = m.invoke(bean, new Object[0]))) continue;
            if (StringUtils.isNotBlank((CharSequence)dateFormat) && value instanceof Date) {
                SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
                map.put(pd.getName(), sdf.format(sdf.parse(value.toString())));
                continue;
            }
            map.put(pd.getName(), value.toString());
        }
        Iterator it = map.entrySet().iterator();
        StringBuilder sb = new StringBuilder(0);
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append((String)entry.getKey()).append("=").append((String)entry.getValue());
        }
        return sb.toString();
    }
}

