/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.core.utils.MGL_StringUtils;
import tech.mgl.core.utils.img.MGL_ImageUtils;

public class MGL_Base64Utils {
    private static final Logger log = LoggerFactory.getLogger(MGL_Base64Utils.class);

    public static synchronized String netImageToBase64(String url) throws Exception {
        return MGL_Base64Utils.netImageToBase64(url, true);
    }

    public static synchronized String netImageToBase64(String url, boolean returnNull) throws Exception {
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        return Base64.getEncoder().encodeToString(MGL_ImageUtils.fetchNetImg(url));
    }

    public static synchronized String encode(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    public static synchronized String encode(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            throw new RuntimeException("encode str can not be null");
        }
        return MGL_Base64Utils.encode(str.getBytes(StandardCharsets.UTF_8));
    }

    public static synchronized byte[] decode(String str) {
        if (MGL_StringUtils.isBlank((CharSequence)str)) {
            throw new RuntimeException("decode str can not be null");
        }
        return Base64.getDecoder().decode(str);
    }

    public static synchronized String decodeToString(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            throw new RuntimeException("decodeToString str can not be null");
        }
        return new String(Objects.requireNonNull(MGL_Base64Utils.decode(str)), StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String imageToBase64(BufferedImage image) {
        String string;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", baos);
            byte[] imageBytes = baos.toByteArray();
            baos.flush();
            baos.close();
            string = Base64.getEncoder().encodeToString(imageBytes);
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        baos.close();
        return string;
    }

    public static String imageToBase64(String imgFilePath) {
        FileInputStream in = null;
        byte[] data = null;
        try {
            in = new FileInputStream(imgFilePath);
            data = new byte[((InputStream)in).available()];
            ((InputStream)in).read(data);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return Base64.getEncoder().encodeToString(data);
    }

    public static synchronized boolean base64ToImage(String imgBase64Str, String imgFilePath) {
        if (imgBase64Str == null) {
            return false;
        }
        try {
            byte[] b = Base64.getDecoder().decode(imgBase64Str);
            for (int i = 0; i < b.length; ++i) {
                if (b[i] >= 0) continue;
                int n = i;
                b[n] = (byte)(b[n] + 256);
            }
            File file = new File(imgFilePath);
            if (!file.exists()) {
                file.getParentFile().mkdirs();
            }
            FileOutputStream out = new FileOutputStream(imgFilePath);
            ((OutputStream)out).write(b);
            out.flush();
            ((OutputStream)out).close();
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

