/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.utils;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import tech.mgl.core.utils.MGL_ObjectUtils;
import tech.mgl.exception.GlobalException;

public class MGL_Asserts {
    public static void notBlank(String text, String message) {
        if (StringUtils.isBlank((CharSequence)text)) {
            throw new GlobalException(message);
        }
    }

    public static void state(boolean expression, String message) {
        if (!expression) {
            throw new GlobalException(message);
        }
    }

    public static <T> T notEmpty(T object, String message) {
        boolean pass = false;
        if (MGL_ObjectUtils.isEmpty(object)) {
            pass = true;
        } else {
            if (object instanceof CharSequence) {
                boolean bl = pass = ((CharSequence)object).length() == 0;
            }
            if (object.getClass().isArray()) {
                boolean bl = pass = Array.getLength(object) == 0;
            }
            if (object instanceof Collection) {
                pass = ((Collection)object).isEmpty();
            }
            if (object instanceof Map) {
                pass = ((Map)object).isEmpty();
            }
        }
        if (pass) {
            throw new GlobalException(message);
        }
        return object;
    }

    public static <T, X extends Throwable> T notNull(T object, Supplier<X> errorSupplier) throws X {
        if (null == object) {
            throw (Throwable)errorSupplier.get();
        }
        return object;
    }

    public static <T> T notNull(T object, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        return MGL_Asserts.notNull(object, () -> new IllegalArgumentException(String.format(errorMsgTemplate, params)));
    }

    public static <T> T notNull(T object) throws IllegalArgumentException {
        return MGL_Asserts.notNull(object, "[Assertion failed] - this argument is required; it must not be null", new Object[0]);
    }
}

