/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.tools.redis;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.redisson.Redisson;
import org.redisson.api.ObjectListener;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RBatch;
import org.redisson.api.RBucket;
import org.redisson.api.RBucketAsync;
import org.redisson.api.RKeys;
import org.redisson.api.RList;
import org.redisson.api.RMap;
import org.redisson.api.RMapAsync;
import org.redisson.api.RRateLimiter;
import org.redisson.api.RSet;
import org.redisson.api.RTopic;
import org.redisson.api.RateIntervalUnit;
import org.redisson.api.RateType;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.core.utils.MGL_ClassUtils;
import tech.mgl.expand.MGL_SpringUtils;

public class MGL_RedisUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)MGL_RedisUtils.class.getSimpleName());
    private static RedissonClient clientInstance = null;

    public static long rateLimiter(String key, RateType rateType, int rate, int rateInterval) {
        RRateLimiter rateLimiter = MGL_RedisUtils.getClient().getRateLimiter(key);
        rateLimiter.trySetRate(rateType, (long)rate, (long)rateInterval, RateIntervalUnit.SECONDS);
        if (rateLimiter.tryAcquire()) {
            return rateLimiter.availablePermits();
        }
        return -1L;
    }

    public static RedissonClient getClient() {
        if (null == clientInstance) {
            boolean present = MGL_ClassUtils.isPresent(RedissonClient.class.getName());
            if (present) {
                clientInstance = MGL_SpringUtils.getBean(RedissonClient.class);
                logger.info("get current getClient() successfully");
            } else {
                Config config = new Config();
                config.useSingleServer().setAddress(String.format("redis://%s:%s", "127.0.0.1", 6379));
                clientInstance = Redisson.create((Config)config);
                logger.info("new redis getClient() successfully");
            }
        }
        return clientInstance;
    }

    public static <T> void publish(String channelKey, T msg, Consumer<T> consumer) {
        RTopic topic = MGL_RedisUtils.getClient().getTopic(channelKey);
        topic.publish(msg);
        consumer.accept(msg);
    }

    public static <T> void publish(String channelKey, T msg) {
        RTopic topic = MGL_RedisUtils.getClient().getTopic(channelKey);
        topic.publish(msg);
    }

    public static <T> void subscribe(String channelKey, Class<T> clazz, Consumer<T> consumer) {
        RTopic topic = MGL_RedisUtils.getClient().getTopic(channelKey);
        topic.addListener(clazz, (channel, msg) -> consumer.accept(msg));
    }

    public static <T> void setCacheObject(String key, T value) {
        MGL_RedisUtils.setCacheObject(key, value, false);
    }

    public static <T> void setCacheObject(String key, T value, boolean isSaveTtl) {
        RBucket bucket = MGL_RedisUtils.getClient().getBucket(key);
        if (isSaveTtl) {
            try {
                bucket.setAndKeepTTL(value);
            }
            catch (Exception e) {
                long timeToLive = bucket.remainTimeToLive();
                MGL_RedisUtils.setCacheObject(key, value, Duration.ofMillis(timeToLive));
            }
        } else {
            bucket.set(value);
        }
    }

    public static <T> void setCacheObject(String key, T value, Duration duration) {
        RBatch batch = MGL_RedisUtils.getClient().createBatch();
        RBucketAsync bucket = batch.getBucket(key);
        bucket.setAsync(value);
        bucket.expireAsync(duration);
        batch.execute();
    }

    public static <T> boolean setObjectIfAbsent(String key, T value, Duration duration) {
        RBucket bucket = MGL_RedisUtils.getClient().getBucket(key);
        return bucket.setIfAbsent(value, duration);
    }

    public static <T> boolean setObjectIfExists(String key, T value, Duration duration) {
        RBucket bucket = MGL_RedisUtils.getClient().getBucket(key);
        return bucket.setIfExists(value, duration);
    }

    public static <T> void addObjectListener(String key, ObjectListener listener) {
        RBucket result = MGL_RedisUtils.getClient().getBucket(key);
        result.addListener(listener);
    }

    public static boolean expire(String key, long timeout) {
        return MGL_RedisUtils.expire(key, Duration.ofSeconds(timeout));
    }

    public static boolean expire(String key, Duration duration) {
        RBucket rBucket = MGL_RedisUtils.getClient().getBucket(key);
        return rBucket.expire(duration);
    }

    public static <T> T getCacheObject(String key) {
        RBucket rBucket = MGL_RedisUtils.getClient().getBucket(key);
        return (T)rBucket.get();
    }

    public static <T> long getTimeToLive(String key) {
        RBucket rBucket = MGL_RedisUtils.getClient().getBucket(key);
        return rBucket.remainTimeToLive();
    }

    public static boolean deleteObject(String key) {
        return MGL_RedisUtils.getClient().getBucket(key).delete();
    }

    public static void deleteObject(Collection collection) {
        RBatch batch = MGL_RedisUtils.getClient().createBatch();
        collection.forEach(t -> batch.getBucket(t.toString()).deleteAsync());
        batch.execute();
    }

    public static boolean isExistsObject(String key) {
        return MGL_RedisUtils.getClient().getBucket(key).isExists();
    }

    public static <T> boolean setCacheList(String key, List<T> dataList) {
        RList rList = MGL_RedisUtils.getClient().getList(key);
        return rList.addAll(dataList);
    }

    public static <T> boolean addCacheList(String key, T data) {
        RList rList = MGL_RedisUtils.getClient().getList(key);
        return rList.add(data);
    }

    public static <T> void addListListener(String key, ObjectListener listener) {
        RList rList = MGL_RedisUtils.getClient().getList(key);
        rList.addListener(listener);
    }

    public static <T> List<T> getCacheList(String key) {
        RList rList = MGL_RedisUtils.getClient().getList(key);
        return rList.readAll();
    }

    public static <T> List<T> getCacheListRange(String key, int form, int to) {
        RList rList = MGL_RedisUtils.getClient().getList(key);
        return rList.range(form, to);
    }

    public static <T> boolean setCacheSet(String key, Set<T> dataSet) {
        RSet rSet = MGL_RedisUtils.getClient().getSet(key);
        return rSet.addAll(dataSet);
    }

    public static <T> boolean addCacheSet(String key, T data) {
        RSet rSet = MGL_RedisUtils.getClient().getSet(key);
        return rSet.add(data);
    }

    public static <T> void addSetListener(String key, ObjectListener listener) {
        RSet rSet = MGL_RedisUtils.getClient().getSet(key);
        rSet.addListener(listener);
    }

    public static <T> Set<T> getCacheSet(String key) {
        RSet rSet = MGL_RedisUtils.getClient().getSet(key);
        return rSet.readAll();
    }

    public static <T> void setCacheMap(String key, Map<String, T> dataMap) {
        if (dataMap != null) {
            RMap rMap = MGL_RedisUtils.getClient().getMap(key);
            rMap.putAll(dataMap);
        }
    }

    public static <T> void addMapListener(String key, ObjectListener listener) {
        RMap rMap = MGL_RedisUtils.getClient().getMap(key);
        rMap.addListener(listener);
    }

    public static <T> Map<String, T> getCacheMap(String key) {
        RMap rMap = MGL_RedisUtils.getClient().getMap(key);
        return rMap.getAll(rMap.keySet());
    }

    public static <T> Set<String> getCacheMapKeySet(String key) {
        RMap rMap = MGL_RedisUtils.getClient().getMap(key);
        return rMap.keySet();
    }

    public static <T> void setCacheMapValue(String key, String hKey, T value) {
        RMap rMap = MGL_RedisUtils.getClient().getMap(key);
        rMap.put((Object)hKey, value);
    }

    public static <T> T getCacheMapValue(String key, String hKey) {
        RMap rMap = MGL_RedisUtils.getClient().getMap(key);
        return (T)rMap.get((Object)hKey);
    }

    public static <T> T delCacheMapValue(String key, String hKey) {
        RMap rMap = MGL_RedisUtils.getClient().getMap(key);
        return (T)rMap.remove((Object)hKey);
    }

    public static <T> void delMultiCacheMapValue(String key, Set<String> hKeys) {
        RBatch batch = MGL_RedisUtils.getClient().createBatch();
        RMapAsync rMap = batch.getMap(key);
        for (String hKey : hKeys) {
            rMap.removeAsync((Object)hKey);
        }
        batch.execute();
    }

    public static <K, V> Map<K, V> getMultiCacheMapValue(String key, Set<K> hKeys) {
        RMap rMap = MGL_RedisUtils.getClient().getMap(key);
        return rMap.getAll(hKeys);
    }

    public static void setAtomicValue(String key, long value) {
        RAtomicLong atomic = MGL_RedisUtils.getClient().getAtomicLong(key);
        atomic.set(value);
    }

    public static long getAtomicValue(String key) {
        RAtomicLong atomic = MGL_RedisUtils.getClient().getAtomicLong(key);
        return atomic.get();
    }

    public static long incrAtomicValue(String key) {
        RAtomicLong atomic = MGL_RedisUtils.getClient().getAtomicLong(key);
        return atomic.incrementAndGet();
    }

    public static long decrAtomicValue(String key) {
        RAtomicLong atomic = MGL_RedisUtils.getClient().getAtomicLong(key);
        return atomic.decrementAndGet();
    }

    public static Collection<String> keys(String pattern) {
        Stream stream = MGL_RedisUtils.getClient().getKeys().getKeysStreamByPattern(pattern);
        return stream.collect(Collectors.toList());
    }

    public static void deleteKeys(String pattern) {
        MGL_RedisUtils.getClient().getKeys().deleteByPattern(pattern);
    }

    public static Boolean hasKey(String key) {
        RKeys rKeys = MGL_RedisUtils.getClient().getKeys();
        return rKeys.countExists(new String[]{key}) > 0L;
    }
}

