/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.tools.redis;

import java.io.File;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import tech.mgl.core.tools.redis.SerializeUtils;
import tech.mgl.core.utils.MGL_PropUtils;
import tech.mgl.core.utils.security.MGL_MD5Utils;

public class MGL_JedisUtils {
    protected static ReentrantLock lockPool = new ReentrantLock();
    protected static ReentrantLock lockJedis = new ReentrantLock();
    protected static Logger logger = LoggerFactory.getLogger(MGL_JedisUtils.class);
    private static String ADDR_ARRAY = "localhost,192.168.0.30,192.168.0.31";
    private static String PORT = "6379,6378,3030";
    private static String AUTH = "mglredis,mglredis,123456";
    private static int MAX_ACTIVE = -1;
    private static int MAX_IDLE = 8;
    private static int MAX_WAIT = 3000;
    private static int TIMEOUT = 10000;
    private static boolean TEST_ON_BORROW = false;
    private static JedisPool jedisPool = null;
    public static final int EXRP_HOUR = 3600;
    public static final int EXRP_DAY = 86400;
    public static final int EXRP_MONTH = 2592000;

    private static void initialPool(int i) {
        try {
            System.out.println(i + " initialPool        -------------------------- ");
            JedisPoolConfig config = new JedisPoolConfig();
            config.setMaxTotal(MAX_ACTIVE);
            config.setMaxIdle(MAX_IDLE);
            config.setMaxWaitMillis((long)MAX_WAIT);
            config.setTestOnBorrow(TEST_ON_BORROW);
            jedisPool = new JedisPool((GenericObjectPoolConfig)config, ADDR_ARRAY.split(",")[i], Integer.parseInt(PORT.split(",")[i]), TIMEOUT, AUTH.split(",")[i]);
            if (jedisPool != null) {
                System.out.println(i + " Create JedisPool error : " + jedisPool.getNumActive());
                jedisPool.getResource();
            }
        }
        catch (Exception e) {
            logger.error(i + " Create JedisPool error : " + String.valueOf(e));
            System.out.println(i + " Create JedisPool error : " + String.valueOf(e));
            MGL_JedisUtils.initialPool(i + 1);
        }
    }

    private static synchronized void poolInit() {
        if (jedisPool == null) {
            MGL_JedisUtils.initialPool(0);
        }
    }

    public static synchronized Jedis getJedis() {
        Jedis jedis;
        block5: {
            if (jedisPool == null) {
                MGL_JedisUtils.poolInit();
            }
            jedis = null;
            try {
                if (jedisPool == null) break block5;
                jedis = jedisPool.getResource();
            }
            catch (Exception e) {
                try {
                    logger.error("Get jedis error : " + String.valueOf(e));
                }
                catch (Throwable throwable) {
                    MGL_JedisUtils.returnResource(jedis);
                    throw throwable;
                }
                MGL_JedisUtils.returnResource(jedis);
            }
        }
        MGL_JedisUtils.returnResource(jedis);
        return jedis;
    }

    public static void returnResource(Jedis jedis) {
        if (jedis != null && jedisPool != null && !jedisPool.isClosed()) {
            jedis.close();
        }
    }

    public static synchronized void set(Object key, Object value) {
        MGL_JedisUtils.set(key, value, -1);
    }

    public static synchronized void set(Object key, Object value, int seconds) {
        try {
            if (null == value) {
                new NullPointerException("Value is can not be null ");
            }
            if (key instanceof String && value instanceof String) {
                MGL_JedisUtils.setString(key.toString(), value.toString(), seconds);
            } else if (seconds > 0) {
                MGL_JedisUtils.getJedis().setex(SerializeUtils.serialize(key), (long)seconds, SerializeUtils.serialize(value));
            } else {
                MGL_JedisUtils.getJedis().set(SerializeUtils.serialize(key), SerializeUtils.serialize(value));
            }
        }
        catch (Exception e) {
            logger.error("Set keyex error : " + String.valueOf(e));
        }
    }

    public static synchronized void setString(String key, String value, int seconds) {
        if (null == value || "".equals(value)) {
            new NullPointerException("Value is can not be null ");
        }
        if (seconds > 0) {
            MGL_JedisUtils.getJedis().setex(MGL_JedisUtils.getKey(key), (long)seconds, value);
        } else {
            MGL_JedisUtils.getJedis().set(MGL_JedisUtils.getKey(key), value);
        }
    }

    public static synchronized void setString(String key, String value) {
        MGL_JedisUtils.setString(key, value, -1);
    }

    private static String getKey(String key) {
        return MGL_MD5Utils.MD5(key);
    }

    public static String getString(String key) {
        String eKey = MGL_JedisUtils.getKey(key);
        Jedis jedis = MGL_JedisUtils.getJedis();
        if (jedis == null || !jedis.exists(eKey)) {
            return null;
        }
        return jedis.get(eKey);
    }

    public static synchronized <T> T get(Object key) {
        if (key instanceof String) {
            String eKey = MGL_JedisUtils.getKey(key.toString());
            Jedis jedis = MGL_JedisUtils.getJedis();
            if (jedis == null || !jedis.exists(eKey)) {
                return MGL_JedisUtils.getObj(key);
            }
            String obj = jedis.get(eKey);
            if (null != obj) {
                return (T)obj;
            }
        }
        return MGL_JedisUtils.getObj(key);
    }

    private static <T> T getObj(Object key) {
        byte[] eKey = SerializeUtils.serialize(key);
        Jedis jedis = MGL_JedisUtils.getJedis();
        if (jedis == null || !jedis.exists(eKey)) {
            return null;
        }
        return (T)SerializeUtils.unserialize(jedis.get(eKey));
    }

    public static synchronized void del(Object key) {
        Object eKey;
        Jedis jedis = MGL_JedisUtils.getJedis();
        if (key instanceof String) {
            eKey = MGL_JedisUtils.getKey(key.toString());
            if (jedis != null && !jedis.exists((String)eKey)) {
                jedis.del((String)eKey);
                eKey = null;
                return;
            }
            eKey = null;
        }
        eKey = SerializeUtils.serialize(key);
        if (jedis != null && !jedis.exists(eKey)) {
            jedis.del(eKey);
        }
        eKey = null;
    }

    static {
        String fileName = "mgl-redis";
        File file = new File(String.valueOf(MGL_JedisUtils.class.getResource("/")) + fileName + ".properties");
        System.out.println("statics:" + file.getAbsolutePath());
        if (file.exists()) {
            String _auth;
            String _port;
            String addr = MGL_PropUtils.getVal("redis.server.addr", fileName);
            if (StringUtils.isNotBlank((CharSequence)addr)) {
                ADDR_ARRAY = addr;
            }
            if (StringUtils.isNotBlank((CharSequence)(_port = MGL_PropUtils.getVal("redis.server.port", fileName)))) {
                PORT = _port;
            }
            if (StringUtils.isNotBlank((CharSequence)(_auth = MGL_PropUtils.getVal("redis.server.auth", fileName)))) {
                AUTH = _auth;
            }
        }
    }
}

