/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.tools;

import java.security.Key;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.core.tools.MGL_RSADecrypt;
import tech.mgl.core.tools.MGL_RSAEncrypt;
import tech.mgl.core.utils.MGL_Base64Utils;

public class MGL_RSAUtils {
    private static final Logger logger = LoggerFactory.getLogger(MGL_RSAUtils.class);
    private static final String PADDING = "RSA/NONE/NoPadding";
    private static final String PROVIDER = "MGL.ASIALOGS.SITE";

    public static synchronized String getPublicKeyString(byte[] data) {
        return MGL_Base64Utils.encode(data);
    }

    public static synchronized String encrypt(MGL_RSAEncrypt rsa) throws Exception {
        Cipher cipher;
        if (null != rsa.getProvider()) {
            cipher = Cipher.getInstance(rsa.getAlgorithm(), rsa.getProvider());
            OAEPParameterSpec oaepParameterSpec = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
            cipher.init(1, (Key)rsa.getPublicKey(), oaepParameterSpec);
        } else {
            cipher = Cipher.getInstance(rsa.getAlgorithm());
        }
        int key_len = ((RSAPublicKey)rsa.getPublicKey()).getModulus().bitLength() / 8;
        String[] datas = MGL_RSAUtils.splitString(rsa.getPlainText(), key_len - 11);
        StringBuilder mi = new StringBuilder();
        for (String s : datas) {
            mi.append(MGL_RSAUtils.bcd2Str(cipher.doFinal(s.getBytes())));
        }
        return MGL_Base64Utils.encode(mi.toString());
    }

    public static byte[] asciiToBCD(byte[] asciiBytes) {
        int length = asciiBytes.length;
        byte[] bcdBytes = new byte[(length + 1) / 2];
        int bcdIndex = 0;
        for (int i = 0; i < length; ++i) {
            byte b = asciiBytes[i];
            if (b >= 48 && b <= 57) {
                if (i % 2 == 0) {
                    bcdBytes[bcdIndex] = (byte)(b - 48 << 4);
                    continue;
                }
                int n = bcdIndex++;
                bcdBytes[n] = (byte)(bcdBytes[n] | (byte)(b - 48));
                continue;
            }
            System.out.println("Skipping non-ASCII character: " + b);
        }
        return bcdBytes;
    }

    public static synchronized String decrypt(MGL_RSADecrypt rsa) throws Exception {
        byte[][] arrays;
        Cipher cipher = null != rsa.getProvider() ? Cipher.getInstance(rsa.getAlgorithm(), rsa.getProvider()) : Cipher.getInstance(rsa.getAlgorithm());
        if (null != rsa.getParams()) {
            cipher.init(2, (Key)rsa.getPrivateKey(), rsa.getParams());
        } else {
            cipher.init(2, rsa.getPrivateKey());
        }
        int key_len = ((RSAPrivateKey)rsa.getPrivateKey()).getModulus().bitLength() / 8;
        byte[] bytes = MGL_Base64Utils.decode(rsa.getCipherText());
        byte[] bcd = MGL_RSAUtils.ASCII_To_BCD(bytes, bytes.length);
        logger.info("plain key text length\uff1a {} , bcd : {}", (Object)(rsa.getKeySize() / 8), (Object)bcd.length);
        if (bcd.length <= rsa.getKeySize() / 8) {
            return new String(cipher.doFinal(bytes));
        }
        StringBuilder ming = new StringBuilder();
        for (byte[] arr : arrays = MGL_RSAUtils.splitArray(bcd, key_len)) {
            ming.append(new String(cipher.doFinal(arr)));
        }
        return ming.toString();
    }

    public static synchronized byte[] ASCII_To_BCD(byte[] ascii, int asc_len) {
        byte[] bcd = new byte[asc_len / 2];
        int j = 0;
        for (int i = 0; i < (asc_len + 1) / 2; ++i) {
            bcd[i] = MGL_RSAUtils.asc_to_bcd(ascii[j++]);
            bcd[i] = (byte)((j >= asc_len ? (byte)0 : MGL_RSAUtils.asc_to_bcd(ascii[j++])) + (bcd[i] << 4));
        }
        return bcd;
    }

    public static byte[] asciiToBCD(String asciiString) {
        int length = asciiString.length();
        byte[] bcdBytes = new byte[(length + 1) / 2];
        int bcdIndex = 0;
        for (int i = 0; i < length; ++i) {
            char c = asciiString.charAt(i);
            if (c >= '0' && c <= '9') {
                if (i % 2 == 0) {
                    bcdBytes[bcdIndex] = (byte)(c - 48 << 4);
                    continue;
                }
                int n = bcdIndex++;
                bcdBytes[n] = (byte)(bcdBytes[n] | (byte)(c - 48));
                continue;
            }
            throw new IllegalArgumentException("Invalid character in ASCII string: " + c);
        }
        return bcdBytes;
    }

    public static synchronized byte asc_to_bcd(byte asc) {
        byte bcd = asc >= 48 && asc <= 57 ? (byte)(asc - 48) : (asc >= 65 && asc <= 70 ? (byte)(asc - 65 + 10) : (asc >= 97 && asc <= 102 ? (byte)(asc - 97 + 10) : (byte)(asc - 48)));
        return bcd;
    }

    public static synchronized String bcd2Str(byte[] bytes) {
        char[] temp = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            char val = (char)((bytes[i] & 0xF0) >> 4 & 0xF);
            temp[i * 2] = (char)(val > '\t' ? val + 65 - 10 : val + 48);
            val = (char)(bytes[i] & 0xF);
            temp[i * 2 + 1] = (char)(val > '\t' ? val + 65 - 10 : val + 48);
        }
        return new String(temp);
    }

    public static synchronized String[] splitString(String string, int len) {
        int x = string.length() / len;
        int y = string.length() % len;
        int z = 0;
        if (y != 0) {
            z = 1;
        }
        String[] strings = new String[x + z];
        String str = "";
        for (int i = 0; i < x + z; ++i) {
            str = i == x + z - 1 && y != 0 ? string.substring(i * len, i * len + y) : string.substring(i * len, i * len + len);
            strings[i] = str;
        }
        return strings;
    }

    public static synchronized byte[][] splitArray(byte[] data, int len) {
        int x = data.length / len;
        int y = data.length % len;
        int z = 0;
        if (y != 0) {
            z = 1;
        }
        byte[][] arrays = new byte[x + z][];
        for (int i = 0; i < x + z; ++i) {
            byte[] arr = new byte[len];
            if (i == x + z - 1 && y != 0) {
                System.arraycopy(data, i * len, arr, 0, y);
            } else {
                System.arraycopy(data, i * len, arr, 0, len);
            }
            arrays[i] = arr;
        }
        return arrays;
    }
}

