/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.tools;

import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import tech.mgl.core.tools.MGL_RSA;
import tech.mgl.core.tools.MGL_RSAUtils;
import tech.mgl.core.utils.MGL_Base64Utils;

public class MGL_RSAEncrypt {
    private final Provider provider;
    private final String modulus;
    private final String exponent;
    private final PublicKey publicKey;
    private final String algorithm;
    private final String plainText;
    private final AlgorithmParameterSpec params;

    public AlgorithmParameterSpec getParams() {
        return this.params;
    }

    public String encrypt() {
        try {
            Cipher cipher = null != this.provider ? Cipher.getInstance(this.algorithm, this.provider) : Cipher.getInstance(this.algorithm);
            if (null != this.params) {
                cipher.init(1, (Key)this.publicKey, this.params);
            } else {
                cipher.init(1, this.publicKey);
            }
            int key_len = ((RSAPublicKey)this.publicKey).getModulus().bitLength() / 8;
            if (this.plainText.length() > key_len - 11) {
                String[] datas = MGL_RSAUtils.splitString(this.plainText, key_len - 11);
                StringBuilder mi = new StringBuilder();
                for (String s : datas) {
                    mi.append(MGL_RSAUtils.bcd2Str(cipher.doFinal(s.getBytes(StandardCharsets.UTF_8))));
                }
                return MGL_Base64Utils.encode(mi.toString());
            }
            return MGL_Base64Utils.encode(cipher.doFinal(this.plainText.getBytes(StandardCharsets.UTF_8)));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    public MGL_RSAEncrypt(MGL_RSA.EncryptBuilder encryptBuilder) {
        this.algorithm = encryptBuilder.getAlgorithm();
        this.plainText = encryptBuilder.getPlainText();
        this.provider = encryptBuilder.getProvider();
        this.modulus = encryptBuilder.getModulus();
        this.exponent = encryptBuilder.getExponent();
        this.publicKey = encryptBuilder.getPublicKey();
        this.params = encryptBuilder.getParams();
    }

    public Provider getProvider() {
        return this.provider;
    }

    public String getModulus() {
        return this.modulus;
    }

    public String getExponent() {
        return this.exponent;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getPlainText() {
        return this.plainText;
    }
}

