/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.tools;

import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.core.tools.MGL_RSA;
import tech.mgl.core.tools.MGL_RSAUtils;
import tech.mgl.core.utils.MGL_Base64Utils;

public class MGL_RSADecrypt {
    private static final Logger logger = LoggerFactory.getLogger(MGL_RSADecrypt.class);
    private final Provider provider;
    private final String modulus;
    private final String exponent;
    private final PrivateKey privateKey;
    private final String algorithm;
    private final String cipherText;
    private final int keySize;
    private final AlgorithmParameterSpec params;

    public MGL_RSADecrypt(MGL_RSA.DecryptBuilder builder) {
        this.algorithm = builder.getAlgorithm();
        this.cipherText = builder.getCipherText();
        this.provider = builder.getProvider();
        this.modulus = builder.getModulus();
        this.exponent = builder.getExponent();
        this.privateKey = builder.getPrivateKey();
        this.keySize = builder.getKeySize();
        this.params = builder.getParams();
    }

    public String decrypt() {
        try {
            byte[][] arrays;
            Cipher cipher = null != this.provider ? Cipher.getInstance(this.algorithm, this.provider) : Cipher.getInstance(this.algorithm);
            if (null != this.params) {
                cipher.init(2, (Key)this.privateKey, this.params);
            } else {
                cipher.init(2, this.privateKey);
            }
            int key_len = ((RSAPrivateKey)this.privateKey).getModulus().bitLength() / 8;
            byte[] ciphertext = MGL_Base64Utils.decode(this.getCipherText());
            byte[] bcd = MGL_RSAUtils.ASCII_To_BCD(ciphertext, ciphertext.length);
            logger.info("plain key text length\uff1a {} , bcd : {}", (Object)(this.keySize / 8), (Object)bcd.length);
            if (bcd.length <= this.keySize / 8) {
                byte[] decryptedBytes = cipher.doFinal(ciphertext);
                return new String(decryptedBytes, StandardCharsets.UTF_8);
            }
            StringBuilder ming = new StringBuilder();
            for (byte[] arr : arrays = MGL_RSAUtils.splitArray(bcd, key_len)) {
                ming.append(new String(cipher.doFinal(arr), StandardCharsets.UTF_8));
            }
            return ming.toString();
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    public AlgorithmParameterSpec getParams() {
        return this.params;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public String getModulus() {
        return this.modulus;
    }

    public String getExponent() {
        return this.exponent;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public String getCipherText() {
        return this.cipherText;
    }
}

