/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.tools;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mgl.core.tools.MGL_RSADecrypt;
import tech.mgl.core.tools.MGL_RSAEncrypt;
import tech.mgl.core.utils.MGL_Base64Utils;

public class MGL_RSA {
    private static final Logger logger = LoggerFactory.getLogger(MGL_RSA.class);
    private final Provider provider;
    private final String algorithm;
    private final int keySize;
    public static final String MAP_KEY_PUBLIC_KEY = "MGL_TECH_PUBLIC_KEY";
    public static final String MAP_KEY_PUBLIC_STRING_KEY = "MGL_TECH_PUBLIC_STRING_KEY";
    public static final String MAP_KEY_PRIVATE_KEY = "MGL_TECH_PRIVATE_KEY";
    public static final String MAP_KEY_PRIVATE_STRING_KEY = "MGL_TECH_PRIVATE_STRING_KEY";

    public MGL_RSA(Builder builder) {
        this.algorithm = builder.getAlgorithm();
        this.provider = builder.getProvider();
        this.keySize = builder.getKeySize();
    }

    public Provider getProvider() {
        return this.provider;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public static DecryptBuilder decryptBuilder() {
        return new DecryptBuilder();
    }

    public static EncryptBuilder encryptBuilder() {
        return new EncryptBuilder();
    }

    public static Builder builder() {
        return new Builder();
    }

    public HashMap<String, Object> genKeys() throws NoSuchAlgorithmException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        KeyPairGenerator keyPairGen = null != this.provider ? KeyPairGenerator.getInstance(this.algorithm, this.provider) : KeyPairGenerator.getInstance(this.algorithm);
        keyPairGen.initialize(this.keySize);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        map.put(MAP_KEY_PUBLIC_KEY, publicKey);
        map.put(MAP_KEY_PRIVATE_KEY, privateKey);
        map.put(MAP_KEY_PRIVATE_STRING_KEY, MGL_Base64Utils.encode(privateKey.getEncoded()));
        map.put(MAP_KEY_PUBLIC_STRING_KEY, MGL_Base64Utils.encode(publicKey.getEncoded()));
        return map;
    }

    public static class Builder {
        protected Provider provider;
        protected String algorithm = "RSA";
        private int keySize = 1024;

        public int getKeySize() {
            return this.keySize;
        }

        public Builder setKeySize(int keySize) {
            this.keySize = keySize;
            return this;
        }

        public Provider getProvider() {
            return this.provider;
        }

        public Builder setProvider(Provider provider) {
            if (null == Security.getProvider(provider.getName())) {
                Security.addProvider(provider);
            }
            this.provider = provider;
            return this;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public Builder setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public MGL_RSA build() {
            return new MGL_RSA(this);
        }
    }

    public static class DecryptBuilder {
        private Provider provider;
        private String modulus;
        private String exponent;
        private String algorithm = "RSA";
        private String keyAlgorithm = "RSA";
        private PrivateKey privateKey;
        protected String cipherText;
        private int keySize = 1024;
        private AlgorithmParameterSpec params;

        public String getKeyAlgorithm() {
            return this.keyAlgorithm;
        }

        public void setKeyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
        }

        public AlgorithmParameterSpec getParams() {
            return this.params;
        }

        public DecryptBuilder setParams(AlgorithmParameterSpec params) {
            this.params = params;
            return this;
        }

        public int getKeySize() {
            return this.keySize;
        }

        public DecryptBuilder setKeySize(int keySize) {
            this.keySize = keySize;
            return this;
        }

        public PrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public DecryptBuilder setPrivateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public void setPrivateKey(String modulus, String exponent) {
            this.setPrivateKey(modulus, exponent, this.provider);
        }

        public void setPrivateKey(String modulus, String exponent, Provider provider) {
            try {
                BigInteger b1 = new BigInteger(modulus);
                BigInteger b2 = new BigInteger(exponent);
                KeyFactory keyFactory = null != provider ? KeyFactory.getInstance(this.keyAlgorithm, provider) : KeyFactory.getInstance(this.keyAlgorithm);
                RSAPrivateKeySpec keySpec = new RSAPrivateKeySpec(b1, b2);
                this.privateKey = keyFactory.generatePrivate(keySpec);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }

        public void setPrivateKey(String privateKey) {
            try {
                logger.warn("set provider and algorithm before set this if you need ");
                KeyFactory keyFactory = null != this.provider ? KeyFactory.getInstance(this.keyAlgorithm, this.provider) : KeyFactory.getInstance(this.keyAlgorithm);
                byte[] bytes = MGL_Base64Utils.decode(privateKey);
                PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(bytes);
                this.privateKey = keyFactory.generatePrivate(pkcs8EncodedKeySpec);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }

        public String getCipherText() {
            return this.cipherText;
        }

        public DecryptBuilder setCipherText(String cipherText) {
            this.cipherText = cipherText;
            return this;
        }

        public Provider getProvider() {
            return this.provider;
        }

        public DecryptBuilder setProvider(Provider provider) {
            if (null == Security.getProvider(provider.getName())) {
                Security.addProvider(provider);
            }
            this.provider = provider;
            return this;
        }

        public String getModulus() {
            return this.modulus;
        }

        public DecryptBuilder setModulus(String modulus) {
            this.modulus = modulus;
            return this;
        }

        public String getExponent() {
            return this.exponent;
        }

        public DecryptBuilder setExponent(String exponent) {
            this.exponent = exponent;
            return this;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public DecryptBuilder setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public MGL_RSADecrypt build() {
            return new MGL_RSADecrypt(this);
        }
    }

    public static class EncryptBuilder {
        private Provider provider;
        private String modulus;
        private String exponent;
        private String algorithm = "RSA";
        private PublicKey publicKey;
        protected String plainText;
        private int keySize = 1024;
        private String keyAlgorithm = "RSA";
        private AlgorithmParameterSpec params;

        public AlgorithmParameterSpec getParams() {
            return this.params;
        }

        public EncryptBuilder setParams(AlgorithmParameterSpec params) {
            this.params = params;
            return this;
        }

        public String getKeyAlgorithm() {
            return this.keyAlgorithm;
        }

        public EncryptBuilder setKeyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            return this;
        }

        public int getKeySize() {
            return this.keySize;
        }

        public EncryptBuilder setKeySize(int keySize) {
            this.keySize = keySize;
            return this;
        }

        public PublicKey getPublicKey() {
            return this.publicKey;
        }

        public EncryptBuilder setPublicKey(PublicKey publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public void setPublicKey(String modulus, String exponent, Provider provider) {
            try {
                BigInteger b1 = new BigInteger(modulus);
                BigInteger b2 = new BigInteger(exponent);
                KeyFactory keyFactory = null != provider ? KeyFactory.getInstance(this.keyAlgorithm, provider) : KeyFactory.getInstance(this.keyAlgorithm);
                RSAPublicKeySpec keySpec = new RSAPublicKeySpec(b1, b2);
                this.publicKey = keyFactory.generatePublic(keySpec);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }

        public void setPublicKey(String publicKey) {
            try {
                KeyFactory keyFactory;
                if (null != this.provider) {
                    System.out.println(this.provider);
                    keyFactory = KeyFactory.getInstance(this.keyAlgorithm, this.provider);
                } else {
                    keyFactory = KeyFactory.getInstance(this.keyAlgorithm);
                }
                byte[] bytes = MGL_Base64Utils.decode(publicKey);
                X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(bytes);
                this.publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }

        public String getPlainText() {
            return this.plainText;
        }

        public EncryptBuilder setPlainText(String plainText) {
            this.plainText = plainText;
            return this;
        }

        public Provider getProvider() {
            return this.provider;
        }

        public EncryptBuilder setProvider(Provider provider) {
            if (null == Security.getProvider(provider.getName())) {
                Security.addProvider(provider);
            }
            this.provider = provider;
            return this;
        }

        public String getModulus() {
            return this.modulus;
        }

        public EncryptBuilder setModulus(String modulus) {
            this.modulus = modulus;
            return this;
        }

        public String getExponent() {
            return this.exponent;
        }

        public EncryptBuilder setExponent(String exponent) {
            this.exponent = exponent;
            return this;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public EncryptBuilder setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public MGL_RSAEncrypt build() {
            return new MGL_RSAEncrypt(this);
        }
    }
}

