/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import tech.mgl.core.stream.MGLIOCopier;
import tech.mgl.core.stream.MGLStreamProgress;
import tech.mgl.core.utils.MGL_Asserts;

public class MGLStreamCopier
extends MGLIOCopier<InputStream, OutputStream> {
    public MGLStreamCopier() {
        this(8192);
    }

    public MGLStreamCopier(int bufferSize) {
        this(bufferSize, -1L);
    }

    public MGLStreamCopier(int bufferSize, long count) {
        this(bufferSize, count, null);
    }

    public MGLStreamCopier(int bufferSize, long count, MGLStreamProgress progress) {
        super(bufferSize, count, progress);
    }

    @Override
    public long copy(InputStream source, OutputStream target) {
        long size;
        MGL_Asserts.notNull(source, "InputStream is null !", new Object[0]);
        MGL_Asserts.notNull(target, "OutputStream is null !", new Object[0]);
        MGLStreamProgress progress = this.progress;
        if (null != progress) {
            progress.start();
        }
        try {
            size = this.doCopy(source, target, new byte[this.bufferSize(this.count)], progress);
            target.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (null != progress) {
            progress.finish();
        }
        return size;
    }

    private long doCopy(InputStream source, OutputStream target, byte[] buffer, MGLStreamProgress progress) throws IOException {
        int read;
        long numToRead = this.count > 0L ? this.count : Long.MAX_VALUE;
        long total = 0L;
        while (numToRead > 0L && (read = source.read(buffer, 0, this.bufferSize(numToRead))) >= 0) {
            target.write(buffer, 0, read);
            if (this.flushEveryBuffer) {
                target.flush();
            }
            numToRead -= (long)read;
            total += (long)read;
            if (null == progress) continue;
            progress.progress(this.count, total);
        }
        return total;
    }
}

