/*
 * Decompiled with CFR 0.152.
 */
package tech.mgl.core.stream;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import tech.mgl.core.stream.MGLIOCopier;
import tech.mgl.core.stream.MGLStreamProgress;
import tech.mgl.core.utils.MGL_Asserts;

public class MGLChannelCopier
extends MGLIOCopier<ReadableByteChannel, WritableByteChannel> {
    public MGLChannelCopier() {
        this(8192);
    }

    public MGLChannelCopier(int bufferSize) {
        this(bufferSize, -1L);
    }

    public MGLChannelCopier(int bufferSize, long count) {
        this(bufferSize, count, null);
    }

    public MGLChannelCopier(int bufferSize, long count, MGLStreamProgress progress) {
        super(bufferSize, count, progress);
    }

    @Override
    public long copy(ReadableByteChannel source, WritableByteChannel target) {
        long size;
        MGL_Asserts.notNull(source, "InputStream is null !", new Object[0]);
        MGL_Asserts.notNull(target, "OutputStream is null !", new Object[0]);
        MGLStreamProgress progress = this.progress;
        if (null != progress) {
            progress.start();
        }
        try {
            size = this.doCopy(source, target, ByteBuffer.allocate(this.bufferSize(this.count)), progress);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (null != progress) {
            progress.finish();
        }
        return size;
    }

    private long doCopy(ReadableByteChannel source, WritableByteChannel target, ByteBuffer buffer, MGLStreamProgress progress) throws IOException {
        int read;
        long numToRead = this.count > 0L ? this.count : Long.MAX_VALUE;
        long total = 0L;
        while (numToRead > 0L && (read = source.read(buffer)) >= 0) {
            buffer.flip();
            target.write(buffer);
            buffer.clear();
            numToRead -= (long)read;
            total += (long)read;
            if (null == progress) continue;
            progress.progress(this.count, total);
        }
        return total;
    }
}

